/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block.entity.clibano;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stal111.forbidden_arcanus.ForbiddenArcanus;
import com.stal111.forbidden_arcanus.core.init.ModBlockEntities;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClibanoFrameBlockEntity
extends BlockEntity {
    @Nullable
    private Direction mainDirection;
    private FrameData frameData = FrameData.EMPTY;

    public ClibanoFrameBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.CLIBANO.get(), pos, state);
    }

    public void setFrameData(FrameData frameData) {
        this.frameData = frameData;
    }

    public FrameData getFrameData() {
        return this.frameData;
    }

    public void setMainDirection(@Nullable Direction mainDirection) {
        this.mainDirection = mainDirection;
    }

    protected void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookupProvider) {
        super.saveAdditional(tag, lookupProvider);
        if (this.frameData != FrameData.EMPTY) {
            FrameData.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.frameData).ifSuccess(tag1 -> tag.merge((CompoundTag)tag1)).ifError(result -> ForbiddenArcanus.LOGGER.warn("Failed to encode Clibano FrameData {}", (Object)result.message()));
        }
        if (this.mainDirection != null) {
            tag.putString("main_direction", this.mainDirection.getName());
        }
    }

    public void loadAdditional(@Nonnull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookupProvider) {
        super.loadAdditional(tag, lookupProvider);
        FrameData.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag).resultOrPartial(arg_0 -> ((Logger)ForbiddenArcanus.LOGGER).error(arg_0)).ifPresent(frameData -> {
            this.frameData = frameData;
        });
        if (tag.contains("main_direction")) {
            this.mainDirection = Direction.byName((String)tag.getString("main_direction"));
        }
    }

    public record FrameData(BlockState replaceState, BlockPos mainPos) {
        public static final FrameData EMPTY = new FrameData(Blocks.AIR.defaultBlockState(), BlockPos.ZERO);
        private static final Codec<FrameData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockState.CODEC.fieldOf("replace_state").forGetter(FrameData::replaceState), (App)BlockPos.CODEC.fieldOf("main_pos").forGetter(FrameData::mainPos)).apply((Applicative)instance, FrameData::new));
    }
}

