/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block.entity.clibano;

import com.stal111.forbidden_arcanus.common.block.clibano.AbstractClibanoFrameBlock;
import com.stal111.forbidden_arcanus.common.block.entity.clibano.ClibanoFireType;
import com.stal111.forbidden_arcanus.common.block.entity.clibano.ClibanoInputSlot;
import com.stal111.forbidden_arcanus.common.block.entity.clibano.ResiduesStorage;
import com.stal111.forbidden_arcanus.common.block.entity.clibano.logic.ClibanoAccessor;
import com.stal111.forbidden_arcanus.common.block.entity.clibano.logic.ClibanoSmeltLogic;
import com.stal111.forbidden_arcanus.common.block.entity.clibano.logic.DefaultSmeltLogic;
import com.stal111.forbidden_arcanus.common.block.entity.clibano.logic.DoubleSmeltLogic;
import com.stal111.forbidden_arcanus.common.block.entity.clibano.residue.ResidueType;
import com.stal111.forbidden_arcanus.common.inventory.clibano.ClibanoMenu;
import com.stal111.forbidden_arcanus.common.item.crafting.ClibanoRecipe;
import com.stal111.forbidden_arcanus.common.item.crafting.ClibanoRecipeInput;
import com.stal111.forbidden_arcanus.common.item.enhancer.EnhancerAccessor;
import com.stal111.forbidden_arcanus.common.item.enhancer.EnhancerDefinition;
import com.stal111.forbidden_arcanus.common.item.enhancer.EnhancerHelper;
import com.stal111.forbidden_arcanus.common.item.enhancer.EnhancerTarget;
import com.stal111.forbidden_arcanus.common.item.enhancer.effect.MultiplySoulDurationEffect;
import com.stal111.forbidden_arcanus.common.network.clientbound.SetClibanoResiduesPayload;
import com.stal111.forbidden_arcanus.core.init.ModBlockEntities;
import com.stal111.forbidden_arcanus.core.init.ModRecipeTypes;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.FurnaceFuelSlot;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import net.valhelsia.valhelsia_core.api.common.block.entity.MenuCreationContext;
import net.valhelsia.valhelsia_core.api.common.block.entity.neoforge.ValhelsiaContainerBlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClibanoMainBlockEntity
extends ValhelsiaContainerBlockEntity<ClibanoMainBlockEntity>
implements RecipeCraftingHolder,
ClibanoAccessor {
    public static final int SOUL_DURATION = 2700;
    public static final int DATA_SOUL_TIME = 0;
    public static final int DATA_BURN_TIME = 1;
    public static final int DATA_BURN_DURATION = 2;
    public static final int DATA_COOKING_PROGRESS_FIRST = 3;
    public static final int DATA_COOKING_PROGRESS_SECOND = 4;
    public static final int DATA_COOKING_DURATION_FIRST = 5;
    public static final int DATA_COOKING_DURATION_SECOND = 6;
    public static final int DATA_FIRE_TYPE = 7;
    public static final int DATA_RESIDUE_FULLNESS = 8;
    public static final int DATA_IS_DOUBLE_RECIPE = 9;
    public static final int DATA_COUNT = 10;
    public static final RecipeType<ClibanoRecipe> RECIPE_TYPE = (RecipeType)ModRecipeTypes.CLIBANO_COMBUSTION.get();
    private final ResiduesStorage residuesStorage = new ResiduesStorage();
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed = new Object2IntOpenHashMap();
    private final CachedRecipeCheck quickCheck;
    private int soulTime;
    private int burnTime;
    private int burnDuration;
    private ClibanoFireType fireType = ClibanoFireType.FIRE;
    private ClibanoFireType nextFireType = ClibanoFireType.FIRE;
    private final ContainerData containerData = new ContainerData(){

        public int get(int index) {
            ClibanoMainBlockEntity blockEntity = ClibanoMainBlockEntity.this;
            return switch (index) {
                case 0 -> blockEntity.soulTime;
                case 1 -> blockEntity.burnTime;
                case 2 -> blockEntity.burnDuration;
                case 3 -> blockEntity.logic.cookingProgress[0];
                case 4 -> blockEntity.logic.cookingProgress[1];
                case 5 -> blockEntity.logic.cookingDuration[0];
                case 6 -> blockEntity.logic.cookingDuration[1];
                case 7 -> blockEntity.fireType.ordinal();
                case 8 -> blockEntity.residuesStorage.getTotalAmount();
                case 9 -> {
                    if (blockEntity.logic instanceof DoubleSmeltLogic) {
                        yield 1;
                    }
                    yield 0;
                }
                default -> 0;
            };
        }

        public void set(int index, int value) {
            ClibanoMainBlockEntity blockEntity = ClibanoMainBlockEntity.this;
            switch (index) {
                case 0: {
                    blockEntity.setSoulTime(value);
                    break;
                }
                case 1: {
                    blockEntity.burnTime = value;
                    break;
                }
                case 2: {
                    blockEntity.burnDuration = value;
                    break;
                }
                case 3: {
                    blockEntity.logic.cookingProgress[0] = value;
                    break;
                }
                case 4: {
                    blockEntity.logic.cookingProgress[1] = value;
                    break;
                }
                case 5: {
                    blockEntity.logic.cookingDuration[0] = value;
                    break;
                }
                case 6: {
                    blockEntity.logic.cookingDuration[1] = value;
                    break;
                }
                case 7: {
                    blockEntity.fireType = ClibanoFireType.values()[value];
                    break;
                }
                case 8: {
                    blockEntity.residuesStorage.setTotalAmount(value);
                }
            }
        }

        public int getCount() {
            return 10;
        }
    };
    private Direction frontDirection = Direction.NORTH;
    private boolean wasLit = false;
    private ClibanoSmeltLogic logic = new DefaultSmeltLogic(this, null, null);
    @Nullable
    private Holder<EnhancerDefinition> enhancer;

    public ClibanoMainBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.CLIBANO_MAIN.get(), pos, state, 7, (slot, stack) -> {
            if (slot == 1) {
                return ClibanoFireType.fromItem(stack) != ClibanoFireType.FIRE;
            }
            if (slot == 2) {
                return stack.getBurnTime(RecipeType.BLASTING) > 0 || FurnaceFuelSlot.isBucket((ItemStack)stack);
            }
            return !slot.equals(ClibanoMenu.RESULT_SLOTS.getFirst()) && !slot.equals(ClibanoMenu.RESULT_SLOTS.getSecond());
        });
        this.quickCheck = new CachedRecipeCheck(() -> this.enhancer != null ? HolderSet.direct((Holder[])new Holder[]{this.enhancer}) : HolderSet.empty());
    }

    public void onLoad() {
        this.nextFireType = this.getFireTypeFromInput();
        this.enhancer = this.updateEnhancer();
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, ClibanoMainBlockEntity blockEntity) {
        ClibanoRecipeInput combinedInput = new ClibanoRecipeInput(blockEntity.getStack((Integer)ClibanoMenu.INPUT_SLOTS.getFirst()), blockEntity.getStack((Integer)ClibanoMenu.INPUT_SLOTS.getSecond()));
        ClibanoRecipeInput firstSlot = new ClibanoRecipeInput(blockEntity.getStack((Integer)ClibanoMenu.INPUT_SLOTS.getFirst()), ItemStack.EMPTY);
        ClibanoRecipeInput secondSlot = new ClibanoRecipeInput(ItemStack.EMPTY, blockEntity.getStack((Integer)ClibanoMenu.INPUT_SLOTS.getSecond()));
        ArrayList<RecipeHolder<ClibanoRecipe>> recipeHolders = new ArrayList<RecipeHolder<ClibanoRecipe>>();
        blockEntity.quickCheck.getAlloyRecipe(combinedInput, level).ifPresentOrElse(recipeHolder -> {
            recipeHolders.add((RecipeHolder<ClibanoRecipe>)recipeHolder);
            if (!(blockEntity.logic instanceof DoubleSmeltLogic)) {
                blockEntity.logic = new DoubleSmeltLogic(blockEntity, (RecipeHolder<ClibanoRecipe>)recipeHolder);
            }
        }, () -> {
            RecipeHolder firstRecipe = blockEntity.quickCheck.getRecipeFor(firstSlot, level).orElse(null);
            RecipeHolder secondRecipe = blockEntity.quickCheck.getRecipeFor(secondSlot, level).orElse(null);
            recipeHolders.add(firstRecipe);
            recipeHolders.add(secondRecipe);
            if (!(blockEntity.logic instanceof DefaultSmeltLogic)) {
                blockEntity.logic = new DefaultSmeltLogic(blockEntity, (RecipeHolder<ClibanoRecipe>)firstRecipe, (RecipeHolder<ClibanoRecipe>)secondRecipe);
            }
        });
        blockEntity.logic.updateRecipes(recipeHolders);
        boolean isLit = blockEntity.burnTime > 0;
        boolean canSmelt = blockEntity.logic.canSmelt();
        ItemStack fuel = blockEntity.getStack(2);
        blockEntity.residuesStorage.tick(blockEntity);
        if (blockEntity.soulTime != 0) {
            --blockEntity.soulTime;
            if (blockEntity.soulTime == 0) {
                blockEntity.changeFireType(level, ClibanoFireType.FIRE);
            }
        } else if (canSmelt && (isLit || !fuel.isEmpty()) && blockEntity.nextFireType != ClibanoFireType.FIRE) {
            blockEntity.consumeSoul(level);
        }
        blockEntity.logic.tick(isLit);
        if (isLit) {
            --blockEntity.burnTime;
        } else {
            if (canSmelt) {
                blockEntity.burnDuration = 0;
                if (!fuel.isEmpty()) {
                    blockEntity.burnDuration = blockEntity.burnTime = blockEntity.getBurnDuration(fuel);
                    fuel.shrink(1);
                    if (!blockEntity.wasLit) {
                        blockEntity.updateAppearance(level);
                    }
                    blockEntity.setChanged();
                }
            }
            if (blockEntity.wasLit) {
                blockEntity.updateAppearance(level);
            }
            blockEntity.wasLit = false;
            return;
        }
        blockEntity.wasLit = true;
    }

    private ClibanoFireType getFireTypeFromInput() {
        ItemStack soul = this.getStack(1);
        if (!soul.isEmpty()) {
            return ClibanoFireType.fromItem(soul);
        }
        return ClibanoFireType.FIRE;
    }

    private static void createExperience(ServerLevel level, Vec3 position, int count, float experience) {
        int i = Mth.floor((float)((float)count * experience));
        float f = Mth.frac((float)((float)count * experience));
        if (f != 0.0f && Math.random() < (double)f) {
            ++i;
        }
        ExperienceOrb.award((ServerLevel)level, (Vec3)position, (int)i);
    }

    @Override
    public boolean canSmelt(@Nullable RecipeHolder<ClibanoRecipe> recipe, ClibanoInputSlot inputSlot) {
        if (recipe == null || this.level == null || inputSlot.apply(slot -> this.getStack(slot).isEmpty())) {
            return false;
        }
        ItemStack stack = ((ClibanoRecipe)recipe.value()).getResultItem((HolderLookup.Provider)this.level.registryAccess());
        if (stack.isEmpty() || (this.soulTime == 0 ? this.nextFireType : this.fireType).ordinal() < ((ClibanoRecipe)recipe.value()).requiredFireType().ordinal()) {
            return false;
        }
        ItemStack resultStack = this.getStack((Integer)ClibanoMenu.RESULT_SLOTS.getFirst());
        ItemStack secondResultStack = this.getStack((Integer)ClibanoMenu.RESULT_SLOTS.getSecond());
        if (resultStack.isEmpty() || secondResultStack.isEmpty()) {
            return true;
        }
        if (!ItemStack.isSameItem((ItemStack)resultStack, (ItemStack)stack) && !ItemStack.isSameItem((ItemStack)secondResultStack, (ItemStack)stack)) {
            return false;
        }
        if (ItemStack.isSameItem((ItemStack)resultStack, (ItemStack)stack) && resultStack.getCount() + stack.getCount() <= this.getMaxStackSize() && resultStack.getCount() + stack.getCount() <= resultStack.getMaxStackSize()) {
            return true;
        }
        if (ItemStack.isSameItem((ItemStack)secondResultStack, (ItemStack)stack) && secondResultStack.getCount() + stack.getCount() <= this.getMaxStackSize() && secondResultStack.getCount() + stack.getCount() <= secondResultStack.getMaxStackSize()) {
            return true;
        }
        return ItemStack.isSameItem((ItemStack)resultStack, (ItemStack)stack) && resultStack.getCount() + stack.getCount() <= stack.getMaxStackSize() || ItemStack.isSameItem((ItemStack)secondResultStack, (ItemStack)stack) && secondResultStack.getCount() + stack.getCount() <= stack.getMaxStackSize();
    }

    @Override
    public void finishRecipe(RecipeHolder<ClibanoRecipe> recipe, ClibanoInputSlot inputSlot) {
        if (this.level == null) {
            return;
        }
        ItemStack stack = ((ClibanoRecipe)recipe.value()).getResultItem((HolderLookup.Provider)this.level.registryAccess());
        inputSlot.apply(slot -> this.getStack(slot).shrink(1));
        for (int i : inputSlot.getIndex()) {
            this.logic.resetCookingProgress(i);
        }
        if (stack.isEmpty()) {
            return;
        }
        ItemStack resultStack = this.getStack((Integer)ClibanoMenu.RESULT_SLOTS.getFirst());
        ItemStack secondResultStack = this.getStack((Integer)ClibanoMenu.RESULT_SLOTS.getSecond());
        if (ItemStack.isSameItem((ItemStack)resultStack, (ItemStack)stack) && resultStack.getCount() + stack.getCount() <= resultStack.getMaxStackSize()) {
            resultStack.grow(stack.getCount());
        } else if (ItemStack.isSameItem((ItemStack)secondResultStack, (ItemStack)stack) && secondResultStack.getCount() + stack.getCount() <= secondResultStack.getMaxStackSize()) {
            secondResultStack.grow(stack.getCount());
        } else if (resultStack.isEmpty()) {
            this.setStack((Integer)ClibanoMenu.RESULT_SLOTS.getFirst(), stack.copy());
        } else if (secondResultStack.isEmpty()) {
            this.setStack((Integer)ClibanoMenu.RESULT_SLOTS.getSecond(), stack.copy());
        }
        this.addResidue((ClibanoRecipe)recipe.value(), this.level.getRandom());
        this.setRecipeUsed(recipe);
    }

    @Override
    public int getCookingTime(RecipeHolder<ClibanoRecipe> recipe) {
        return ((ClibanoRecipe)recipe.value()).cookingTimes().get(this.fireType);
    }

    private void addResidue(ClibanoRecipe recipe, RandomSource random) {
        if (this.fireType == ClibanoFireType.FIRE) {
            return;
        }
        recipe.residueChance().ifPresent(chance -> {
            if (random.nextDouble() < chance.chance()) {
                this.residuesStorage.increaseType(chance.type(), 1);
                Level patt0$temp = this.level;
                if (patt0$temp instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)patt0$temp;
                    PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new SetClibanoResiduesPayload(this.residuesStorage), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        });
    }

    private void changeFireType(Level level, ClibanoFireType fireType) {
        this.fireType = fireType;
        this.logic.onFireTypeChange(fireType);
        this.updateAppearance(level);
        this.setChanged();
    }

    private void updateAppearance(Level level) {
        BlockPos front = this.worldPosition.relative(this.frontDirection);
        this.updateAppearance(level, front);
        for (Direction direction : Direction.values()) {
            if (direction.getAxis() == this.frontDirection.getAxis()) continue;
            this.updateAppearance(level, front.relative(direction));
        }
    }

    private void updateAppearance(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof AbstractClibanoFrameBlock) {
            AbstractClibanoFrameBlock clibanoFrameBlock = (AbstractClibanoFrameBlock)block;
            level.setBlockAndUpdate(pos, clibanoFrameBlock.updateAppearance(state, this.burnTime > 0, this.fireType));
        }
    }

    private void consumeSoul(Level level) {
        this.soulTime = 2700;
        if (this.enhancer != null) {
            ((EnhancerDefinition)this.enhancer.value()).getEffects(EnhancerTarget.CLIBANO).forEach(enhancerEffect -> {
                if (enhancerEffect instanceof MultiplySoulDurationEffect) {
                    MultiplySoulDurationEffect effect = (MultiplySoulDurationEffect)enhancerEffect;
                    this.soulTime = effect.getModifiedValue(this.soulTime);
                }
            });
        }
        this.changeFireType(level, this.nextFireType);
        this.getStack(1).shrink(1);
        this.onSlotChanged(1);
    }

    public void setFrontDirection(Direction direction) {
        this.frontDirection = direction;
    }

    @NotNull
    protected Component getDefaultName() {
        return Component.translatable((String)"container.forbidden_arcanus.clibano");
    }

    protected AbstractContainerMenu createMenu(int containerId, @NotNull MenuCreationContext context) {
        return new ClibanoMenu(containerId, this.getItemStackHandler(), this.containerData, (Map<Holder<ResidueType>, Integer>)this.residuesStorage.getResidueTypeAmountMap(), (MenuCreationContext<ClibanoMainBlockEntity, IItemHandler>)context);
    }

    protected void onSlotChanged(int slot) {
        if (slot == 1) {
            this.nextFireType = this.getFireTypeFromInput();
        } else if (slot == 0) {
            this.enhancer = this.updateEnhancer();
        }
    }

    @Nullable
    private Holder<EnhancerDefinition> updateEnhancer() {
        return EnhancerHelper.getEnhancerHolder((HolderLookup.Provider)this.level.registryAccess(), this.getStack(0)).orElse(null);
    }

    protected void saveAdditional(@NotNull CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.saveAdditional(tag, lookupProvider);
        this.saveInventory(tag, lookupProvider);
        tag.putInt("soul_time", this.soulTime);
        tag.putInt("burn_time", this.burnTime);
        tag.putIntArray("cooking_times", this.logic.cookingProgress);
        tag.putIntArray("cooking_durations", this.logic.cookingDuration);
        tag.putString("fire_type", this.fireType.getSerializedName());
        tag.putString("front_direction", this.frontDirection.getName());
        CompoundTag recipesUsed = new CompoundTag();
        this.recipesUsed.forEach((resourceLocation, integer) -> recipesUsed.putInt(resourceLocation.toString(), integer.intValue()));
        tag.put("recipes_used", (Tag)recipesUsed);
        if (this.residuesStorage.shouldBeSaved() && this.level != null) {
            this.residuesStorage.save(tag, lookupProvider);
        }
    }

    protected void loadAdditional(@NotNull CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.loadAdditional(tag, lookupProvider);
        this.loadInventory(tag, lookupProvider);
        this.soulTime = tag.getInt("soul_time");
        this.burnTime = tag.getInt("burn_time");
        this.burnDuration = this.getBurnDuration(this.getStack(2));
        this.logic.cookingProgress = tag.getIntArray("cooking_times");
        this.logic.cookingDuration = tag.getIntArray("cooking_durations");
        this.fireType = (ClibanoFireType)ClibanoFireType.CODEC.byName(tag.getString("fire_type"), (Enum)ClibanoFireType.FIRE);
        this.frontDirection = Direction.byName((String)tag.getString("front_direction"));
        CompoundTag recipesUsed = tag.getCompound("recipes_used");
        for (String recipe : recipesUsed.getAllKeys()) {
            this.recipesUsed.put((Object)ResourceLocation.parse((String)recipe), tag.getInt(recipe));
        }
        this.residuesStorage.load(tag, lookupProvider);
    }

    public void setSoulTime(int duration) {
        this.soulTime = duration;
    }

    protected int getBurnDuration(ItemStack fuel) {
        if (fuel.isEmpty()) {
            return 0;
        }
        return fuel.getBurnTime(RECIPE_TYPE);
    }

    public ResiduesStorage getResiduesStorage() {
        return this.residuesStorage;
    }

    @Nullable
    public RecipeHolder<?> getRecipeUsed() {
        return null;
    }

    public void setRecipeUsed(@Nullable RecipeHolder<?> recipe) {
        if (recipe == null) {
            return;
        }
        this.recipesUsed.addTo((Object)recipe.id(), 1);
    }

    public void awardUsedRecipesAndPopExperience(ServerPlayer player) {
        player.awardRecipes(this.getRecipesToAwardAndPopExperience(player.serverLevel(), player.position()));
        this.recipesUsed.clear();
    }

    public Collection<RecipeHolder<?>> getRecipesToAwardAndPopExperience(ServerLevel level, Vec3 position) {
        ArrayList list = new ArrayList();
        for (Object2IntMap.Entry entry : this.recipesUsed.object2IntEntrySet()) {
            level.getRecipeManager().byKey((ResourceLocation)entry.getKey()).ifPresent(recipe -> {
                list.add((RecipeHolder<?>)recipe);
                ClibanoMainBlockEntity.createExperience(level, position, entry.getIntValue(), ((ClibanoRecipe)recipe.value()).getExperience());
            });
        }
        return list;
    }

    public static class CachedRecipeCheck
    implements RecipeManager.CachedCheck<ClibanoRecipeInput, ClibanoRecipe> {
        @Nullable
        private RecipeHolder<ClibanoRecipe> lastAlloyRecipe;
        private final Queue<RecipeHolder<ClibanoRecipe>> lastRecipes = new LinkedList<RecipeHolder<ClibanoRecipe>>();
        private final EnhancerAccessor accessor;

        public CachedRecipeCheck(EnhancerAccessor accessor) {
            this.accessor = accessor;
        }

        @NotNull
        public Optional<RecipeHolder<ClibanoRecipe>> getRecipeFor(@NotNull ClibanoRecipeInput recipeInput, @NotNull Level level) {
            Optional<RecipeHolder<ClibanoRecipe>> optional;
            while (!this.lastRecipes.isEmpty()) {
                optional = this.checkRecipe(this.lastRecipes.poll(), recipeInput, level);
                if (!optional.isPresent()) continue;
                return optional;
            }
            optional = level.getRecipeManager().getAllRecipesFor(RECIPE_TYPE).stream().filter(recipe -> !((ClibanoRecipe)recipe.value()).isDoubleRecipe() && ((ClibanoRecipe)recipe.value()).matches(recipeInput, level, this.accessor.getEnhancers())).findFirst();
            optional.ifPresent(this.lastRecipes::add);
            return optional;
        }

        public Optional<RecipeHolder<ClibanoRecipe>> getAlloyRecipe(ClibanoRecipeInput recipeInput, Level level) {
            return Optional.ofNullable(this.checkRecipe(this.lastAlloyRecipe, recipeInput, level).orElseGet(() -> {
                for (RecipeHolder recipe : level.getRecipeManager().getAllRecipesFor(RECIPE_TYPE)) {
                    if (((ClibanoRecipe)recipe.value()).isDoubleRecipe() && ((ClibanoRecipe)recipe.value()).matches(recipeInput, level, this.accessor.getEnhancers())) {
                        this.lastAlloyRecipe = recipe;
                        return recipe;
                    }
                    this.lastRecipes.add((RecipeHolder<ClibanoRecipe>)recipe);
                }
                return null;
            }));
        }

        private Optional<RecipeHolder<ClibanoRecipe>> checkRecipe(@Nullable RecipeHolder<ClibanoRecipe> recipeHolder, ClibanoRecipeInput recipeInput, Level level) {
            if (recipeHolder != null && ((ClibanoRecipe)recipeHolder.value()).matches(recipeInput, level, this.accessor.getEnhancers())) {
                return Optional.of(recipeHolder);
            }
            return Optional.empty();
        }
    }
}

