/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.item;

import com.stal111.forbidden_arcanus.common.block.entity.forge.essence.EssenceType;
import com.stal111.forbidden_arcanus.common.essence.EssenceHelper;
import com.stal111.forbidden_arcanus.common.essence.EssenceStorage;
import com.stal111.forbidden_arcanus.common.essence.EssenceValue;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FastColor;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;

public class AurealTankItem
extends Item {
    public static final int DEFAULT_CAPACITY = 100;
    public static final int MAX_CAPACITY = 3000;
    public static final EssenceStorage DEFAULT_DATA = new EssenceStorage(EssenceValue.createEmpty(EssenceType.AUREAL), 3000, true);
    private static final int BAR_COLOR = FastColor.ARGB32.color((int)255, (int)159, (int)226, (int)253);

    public AurealTankItem(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> components, @NotNull TooltipFlag flag) {
        EssenceHelper.getEssenceStorage(stack).ifPresent(storage -> components.add((Component)Component.translatable((String)"tooltip.forbidden_arcanus.aureal_tank.tier", (Object[])new Object[]{storage.limit() / 100}).withStyle(ChatFormatting.GRAY)));
    }

    public int getBarColor(@NotNull ItemStack stack) {
        return BAR_COLOR;
    }

    public boolean isBarVisible(@NotNull ItemStack stack) {
        return true;
    }

    public int getBarWidth(@NotNull ItemStack stack) {
        return EssenceHelper.getEssenceStorage(stack).map(storage -> Math.round(13.0f * storage.getFillPercentage())).orElse(0);
    }

    public boolean isEnabled(FeatureFlagSet enabledFeatures) {
        return false;
    }
}

