/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.item;

import com.stal111.forbidden_arcanus.common.entity.projectile.AurealMissile;
import com.stal111.forbidden_arcanus.common.essence.EssenceHelper;
import com.stal111.forbidden_arcanus.core.init.ModDataComponents;
import com.stal111.forbidden_arcanus.core.init.ModSounds;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class MagicWandItem
extends Item {
    private static final float CHARGE_DURATION = 30.0f;

    public MagicWandItem(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag flag) {
        stack.addToTooltip(ModDataComponents.WAND_PARTS, context, components::add, flag);
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.getItemInHand(usedHand);
        if (EssenceHelper.hasEnoughAureal(level, (LivingEntity)player, stack)) {
            player.startUsingItem(usedHand);
            return InteractionResultHolder.consume((Object)player.getItemInHand(usedHand));
        }
        return super.use(level, player, usedHand);
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity livingEntity, int timeLeft) {
        if (!level.isClientSide() && (float)(stack.getUseDuration(livingEntity) - timeLeft) >= 30.0f && EssenceHelper.hasEnoughAureal(level, livingEntity, stack)) {
            this.shootProjectile(level, livingEntity);
            EssenceHelper.consumeAureal(livingEntity, stack);
        }
    }

    private void shootProjectile(Level level, LivingEntity livingEntity) {
        AurealMissile aurealMissile = new AurealMissile(livingEntity, level, livingEntity.position().x(), livingEntity.getEyePosition().y(), livingEntity.position().z());
        aurealMissile.shootFromRotation((Entity)livingEntity, livingEntity.getXRot(), livingEntity.getYRot(), 0.0f, 1.1f, 0.5f);
        level.addFreshEntity((Entity)aurealMissile);
        level.playSound(null, livingEntity.getX(), livingEntity.getY(), livingEntity.getZ(), (SoundEvent)ModSounds.MAGIC_WAND_CAST.get(), livingEntity.getSoundSource(), 1.0f, 1.0f + (level.random.nextFloat() - level.random.nextFloat()) * 0.2f);
    }

    public static float getUseProgress(ItemStack stack, LivingEntity entity) {
        return entity.isUsingItem() ? Math.min(30.0f, (float)(stack.getUseDuration(entity) - entity.getUseItemRemainingTicks())) / 30.0f : 0.0f;
    }
}

