/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stal111.forbidden_arcanus.ForbiddenArcanus;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;

public record ToggleableState(boolean active, boolean showInTooltip) implements TooltipProvider
{
    public static final Codec<ToggleableState> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("active", (Object)true).forGetter(ToggleableState::active), (App)Codec.BOOL.optionalFieldOf("showInTooltip", (Object)true).forGetter(ToggleableState::showInTooltip)).apply((Applicative)instance, ToggleableState::new));
    public static final StreamCodec<FriendlyByteBuf, ToggleableState> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, ToggleableState::active, (StreamCodec)ByteBufCodecs.BOOL, ToggleableState::showInTooltip, ToggleableState::new);
    public static final ToggleableState DEFAULT = new ToggleableState(true, true);
    private static final Component TOGGLE = Component.translatable((String)Util.makeDescriptionId((String)"item", (ResourceLocation)ForbiddenArcanus.location("toggle_state"))).withStyle(ChatFormatting.GRAY);
    private static final Component TOGGLE_ACTIVATED = Component.translatable((String)Util.makeDescriptionId((String)"item", (ResourceLocation)ForbiddenArcanus.location("toggle_state.activated"))).withStyle(ChatFormatting.GREEN).append(" ").append(TOGGLE);
    private static final Component TOGGLE_DEACTIVATED = Component.translatable((String)Util.makeDescriptionId((String)"item", (ResourceLocation)ForbiddenArcanus.location("toggle_state.deactivated"))).withStyle(ChatFormatting.RED).append(" ").append(TOGGLE);

    public ToggleableState toggle() {
        return new ToggleableState(!this.active, this.showInTooltip);
    }

    public void addToTooltip(Item.TooltipContext context, Consumer<Component> tooltipAdder, TooltipFlag tooltipFlag) {
        if (this.showInTooltip) {
            tooltipAdder.accept(this.active ? TOGGLE_ACTIVATED : TOGGLE_DEACTIVATED);
        }
    }
}

