/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.world.feature;

import com.mojang.serialization.Codec;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;

public class RootFeature
extends Feature<BlockStateConfiguration> {
    private static final double DIRECTION_CHANGE_CHANCE = 0.25;

    public RootFeature(Codec<BlockStateConfiguration> codec) {
        super(codec);
    }

    public boolean place(@Nonnull FeaturePlaceContext<BlockStateConfiguration> context) {
        WorldGenLevel level = context.level();
        BlockState state = ((BlockStateConfiguration)context.config()).state;
        BlockPos.MutableBlockPos pos = context.origin().mutable();
        RandomSource rand = context.random();
        level.setBlock((BlockPos)pos, state, 2);
        for (int i = 1; i < 6 && level.isEmptyBlock((BlockPos)(pos = this.tryChangeDirection(level, pos.move(Direction.DOWN), rand, 0.25))); ++i) {
            level.setBlock((BlockPos)pos, state, 2);
        }
        return true;
    }

    private BlockPos.MutableBlockPos tryChangeDirection(WorldGenLevel level, BlockPos.MutableBlockPos pos, RandomSource random, double chance) {
        if ((double)random.nextFloat() >= chance) {
            return pos;
        }
        Direction direction = this.getRandomDirection(random);
        BlockPos.MutableBlockPos relativePos = pos.move(direction);
        return !level.getBlockState((BlockPos)relativePos).isSolidRender((BlockGetter)level, (BlockPos)relativePos) ? relativePos : pos;
    }

    private Direction getRandomDirection(RandomSource random) {
        return Direction.from2DDataValue((int)random.nextInt(4));
    }
}

