/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.itemcollectors;

import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.core.block.BaseBlockEntity;
import com.supermartijn642.core.block.BaseBlockEntityType;
import com.supermartijn642.core.block.TickableBlockEntity;
import com.supermartijn642.itemcollectors.CollectorBlock;
import com.supermartijn642.itemcollectors.ItemCollectors;
import com.supermartijn642.itemcollectors.ItemCollectorsConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public class CollectorBlockEntity
extends BaseBlockEntity
implements TickableBlockEntity {
    private static final int MIN_RANGE = 1;
    private final Supplier<Integer> maxRange;
    private final Supplier<Boolean> hasFilter;
    public int rangeX;
    public int rangeY;
    public int rangeZ;
    public final List<ItemStack> filter = new ArrayList<ItemStack>(9);
    public boolean filterWhitelist;
    public boolean filterDurability = true;
    public boolean showArea = false;

    public static CollectorBlockEntity basicCollectorEntity(BlockPos pos, BlockState state) {
        return new CollectorBlockEntity(ItemCollectors.basic_collector_tile, pos, state, ItemCollectorsConfig.basicCollectorMaxRange, ItemCollectorsConfig.basicCollectorFilter);
    }

    public static CollectorBlockEntity advancedCollectorEntity(BlockPos pos, BlockState state) {
        return new CollectorBlockEntity(ItemCollectors.advanced_collector_tile, pos, state, ItemCollectorsConfig.advancedCollectorMaxRange, ItemCollectorsConfig.advancedCollectorFilter);
    }

    public CollectorBlockEntity(BaseBlockEntityType<CollectorBlockEntity> blockEntityType, BlockPos pos, BlockState state, Supplier<Integer> maxRange, Supplier<Boolean> hasFilter) {
        super(blockEntityType, pos, state);
        this.maxRange = maxRange;
        this.rangeY = this.rangeZ = (int)Math.ceil((float)maxRange.get().intValue() / 2.0f);
        this.rangeX = this.rangeZ;
        this.hasFilter = hasFilter;
        for (int i = 0; i < 9; ++i) {
            this.filter.add(ItemStack.EMPTY);
        }
    }

    public void update() {
        IItemHandler itemHandler;
        if (!this.level.isClientSide && (itemHandler = this.getOutputItemHandler()) != null) {
            if (itemHandler.getSlots() <= 0) {
                return;
            }
            AABB area = this.getAffectedArea();
            List items = this.level.getEntitiesOfClass(ItemEntity.class, area, item -> {
                if (!item.isAlive() || item.getPersistentData().contains("PreventRemoteMovement") && !item.getPersistentData().contains("AllowMachineRemoteMovement")) {
                    return false;
                }
                ItemStack stack = item.getItem();
                if (stack.isEmpty()) {
                    return false;
                }
                if (!this.hasFilter.get().booleanValue()) {
                    return true;
                }
                for (int i = 0; i < 9; ++i) {
                    ItemStack filter = this.filter.get(i);
                    if (!ItemStack.isSameItem((ItemStack)filter, (ItemStack)stack) || this.filterDurability && !ItemStack.isSameItemSameComponents((ItemStack)filter, (ItemStack)stack)) continue;
                    return this.filterWhitelist;
                }
                return !this.filterWhitelist;
            });
            block0: for (ItemEntity entity : items) {
                ItemStack stack = entity.getItem().copy();
                for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
                    if (!itemHandler.isItemValid(slot, stack) || !(stack = itemHandler.insertItem(slot, stack, false)).isEmpty()) continue;
                    entity.setItem(ItemStack.EMPTY);
                    entity.remove(Entity.RemovalReason.DISCARDED);
                    continue block0;
                }
                entity.setItem(stack);
            }
        }
    }

    public AABB getAffectedArea() {
        return AABB.encapsulatingFullBlocks((BlockPos)this.worldPosition.offset(-this.rangeX, -this.rangeY, -this.rangeZ), (BlockPos)this.worldPosition.offset(this.rangeX, this.rangeY, this.rangeZ));
    }

    private IItemHandler getOutputItemHandler() {
        BlockState state = this.getBlockState();
        if (!state.hasProperty(CollectorBlock.DIRECTION)) {
            return null;
        }
        Direction direction = (Direction)state.getValue(CollectorBlock.DIRECTION);
        return (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, this.worldPosition.relative(direction), null);
    }

    public void setRangeX(int range) {
        int old = this.rangeX;
        this.rangeX = Math.min(Math.max(range, 1), this.maxRange.get());
        if (this.rangeX != old) {
            this.dataChanged();
        }
    }

    public void setRangeY(int range) {
        int old = this.rangeY;
        this.rangeY = Math.min(Math.max(range, 1), this.maxRange.get());
        if (this.rangeY != old) {
            this.dataChanged();
        }
    }

    public void setRangeZ(int range) {
        int old = this.rangeZ;
        this.rangeZ = Math.min(Math.max(range, 1), this.maxRange.get());
        if (this.rangeZ != old) {
            this.dataChanged();
        }
    }

    public void setShowArea(boolean showArea) {
        if (this.showArea != showArea) {
            this.showArea = showArea;
            this.dataChanged();
        }
    }

    protected CompoundTag writeData() {
        CompoundTag tag = new CompoundTag();
        tag.putInt("rangeX", this.rangeX);
        tag.putInt("rangeY", this.rangeY);
        tag.putInt("rangeZ", this.rangeZ);
        for (int i = 0; i < 9; ++i) {
            if (this.filter.get(i).isEmpty()) continue;
            tag.put("filter" + i, this.filter.get(i).save((HolderLookup.Provider)this.level.registryAccess()));
        }
        tag.putBoolean("filterWhitelist", this.filterWhitelist);
        tag.putBoolean("filterDurability", this.filterDurability);
        tag.putBoolean("showArea", this.showArea);
        return tag;
    }

    protected void readData(CompoundTag tag) {
        if (tag.contains("rangeX")) {
            this.rangeX = tag.getInt("rangeX");
        }
        if (tag.contains("rangeY")) {
            this.rangeY = tag.getInt("rangeY");
        }
        if (tag.contains("rangeZ")) {
            this.rangeZ = tag.getInt("rangeZ");
        }
        for (int i = 0; i < 9; ++i) {
            this.filter.set(i, tag.contains("filter" + i) ? ItemStack.parseOptional((HolderLookup.Provider)CommonUtils.getRegistryAccess(), (CompoundTag)tag.getCompound("filter" + i)) : ItemStack.EMPTY);
        }
        this.filterWhitelist = tag.contains("filterWhitelist") && tag.getBoolean("filterWhitelist");
        this.filterDurability = tag.contains("filterDurability") && tag.getBoolean("filterDurability");
        this.showArea = tag.contains("showArea") && tag.getBoolean("showArea");
    }
}

