/*
 * Decompiled with CFR 0.152.
 */
package com.github.bigenergy.glassential.blocks.entity;

import com.github.bigenergy.glassential.init.GlassentialBlockEntities;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.Nullable;

public class OneWayGlassBlockEntity
extends BlockEntity {
    public static final ModelProperty<BlockState> MIMIC = new ModelProperty();
    private BlockState mimic = Blocks.GLASS.defaultBlockState();

    public OneWayGlassBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)GlassentialBlockEntities.ONE_WAY_GLASS.get(), pos, state);
    }

    public ModelData getModelData() {
        return ModelData.builder().with(MIMIC, (Object)this.mimic).build();
    }

    public void setMimic(BlockState state) {
        this.mimic = state;
        this.setChanged();
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            server.getChunkSource().blockChanged(this.worldPosition);
            server.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
        }
        this.requestModelDataUpdate();
    }

    public BlockState getMimic() {
        return this.mimic;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider lookup) {
        super.saveAdditional(tag, lookup);
        ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)this.mimic.getBlock());
        if (id != null) {
            tag.putString("Mimic", id.toString());
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider lookup) {
        Optional opt;
        ResourceLocation id;
        super.loadAdditional(tag, lookup);
        BlockState def = Blocks.IRON_BLOCK.defaultBlockState();
        if (tag.contains("Mimic") && (id = ResourceLocation.tryParse((String)tag.getString("Mimic"))) != null && (opt = BuiltInRegistries.BLOCK.getOptional(id)).isPresent()) {
            def = ((Block)opt.get()).defaultBlockState();
        }
        this.mimic = def;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider lookup) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, lookup);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookup) {
        this.loadAdditional(tag, lookup);
        this.requestModelDataUpdate();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookup) {
        CompoundTag tag = pkt.getTag();
        if (tag != null) {
            this.loadAdditional(tag, lookup);
            this.requestModelDataUpdate();
            if (this.level != null && Minecraft.getInstance().levelRenderer != null) {
                Minecraft.getInstance().levelRenderer.blockChanged((BlockGetter)this.level, this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
            }
        }
    }
}

