/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.api.unification.bundled;

import com.almostreliable.unified.api.unification.bundled.GenericRecipeUnifier;
import com.almostreliable.unified.api.unification.recipe.RecipeData;
import com.almostreliable.unified.api.unification.recipe.RecipeJson;
import com.almostreliable.unified.api.unification.recipe.RecipeUnifier;
import com.almostreliable.unified.api.unification.recipe.UnificationHelper;
import net.minecraft.resources.ResourceLocation;

public final class SmithingRecipeUnifier
implements RecipeUnifier {
    public static final SmithingRecipeUnifier INSTANCE = new SmithingRecipeUnifier();
    public static final ResourceLocation TRANSFORM_TYPE = ResourceLocation.withDefaultNamespace((String)"smithing_transform");
    public static final ResourceLocation TRIM_TYPE = ResourceLocation.withDefaultNamespace((String)"smithing_trim");
    public static final String ADDITION_PROPERTY = "addition";
    public static final String BASE_PROPERTY = "base";
    public static final String TEMPLATE_PROPERTY = "template";

    @Override
    public void unify(UnificationHelper helper, RecipeJson recipe) {
        GenericRecipeUnifier.INSTANCE.unify(helper, recipe);
        helper.unifyInputs(recipe, ADDITION_PROPERTY, BASE_PROPERTY, TEMPLATE_PROPERTY);
    }

    public static boolean isApplicable(RecipeData recipe) {
        return recipe.getType().equals((Object)TRANSFORM_TYPE) || recipe.getType().equals((Object)TRIM_TYPE) || SmithingRecipeUnifier.hasSmithingLikeStructure(recipe);
    }

    private static boolean hasSmithingLikeStructure(RecipeData recipe) {
        return recipe.hasProperty(ADDITION_PROPERTY) && recipe.hasProperty(BASE_PROPERTY) && recipe.hasProperty("result");
    }
}

