/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.config;

import com.almostreliable.unified.api.unification.Placeholders;
import com.almostreliable.unified.config.Config;
import com.almostreliable.unified.config.Defaults;
import com.almostreliable.unified.utils.JsonUtils;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;

public final class PlaceholderConfig
extends Config
implements Placeholders {
    public static final String NAME = "placeholders";
    public static final PlaceholderSerializer SERIALIZER = new PlaceholderSerializer();
    private final Map<String, Collection<String>> placeholders;

    private PlaceholderConfig(Map<String, Collection<String>> placeholders) {
        super(NAME);
        this.placeholders = placeholders;
    }

    @Override
    public Collection<String> apply(String str) {
        AtomicReference inflated = new AtomicReference(new HashSet());
        ((Collection)inflated.get()).add(str);
        this.forEach((placeholder, replacements) -> inflated.set(PlaceholderConfig.inflate((Collection)inflated.get(), placeholder, replacements)));
        return inflated.get();
    }

    @Override
    public Collection<String> getPlaceholders() {
        return Collections.unmodifiableCollection(this.placeholders.keySet());
    }

    @Override
    public Collection<String> getReplacements(String placeholder) {
        return this.placeholders.getOrDefault(placeholder, Collections.emptyList());
    }

    @Override
    public void forEach(BiConsumer<String, Collection<String>> consumer) {
        this.placeholders.forEach(consumer);
    }

    private static Collection<String> inflate(Collection<String> values, String placeholder, Collection<String> replacements) {
        String formattedPlaceholder = "{" + placeholder + "}";
        HashSet<String> result = new HashSet<String>();
        for (String value : values) {
            for (String replacement : replacements) {
                result.add(value.replace(formattedPlaceholder, replacement));
            }
        }
        return result;
    }

    public static final class PlaceholderSerializer
    extends Config.Serializer<PlaceholderConfig> {
        private PlaceholderSerializer() {
        }

        @Override
        public PlaceholderConfig handleDeserialization(JsonObject json) {
            if (json.size() == 0) {
                this.setInvalid();
                return new PlaceholderConfig(Defaults.PLACEHOLDERS);
            }
            Map<String, Collection<String>> replacements = this.safeGet(() -> {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (Map.Entry entry : json.entrySet()) {
                    ImmutableSet.Builder placeholders = ImmutableSet.builder();
                    for (JsonElement element : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                        if (!element.isJsonPrimitive()) continue;
                        placeholders.add((Object)element.getAsString().trim());
                    }
                    builder.put((Object)((String)entry.getKey()).trim(), (Object)placeholders.build());
                }
                return builder.build();
            }, Defaults.PLACEHOLDERS);
            return new PlaceholderConfig(replacements);
        }

        @Override
        public JsonObject serialize(PlaceholderConfig config) {
            JsonObject json = new JsonObject();
            for (Map.Entry<String, Collection<String>> entry : config.placeholders.entrySet()) {
                json.add(entry.getKey(), (JsonElement)JsonUtils.toArray((Iterable<String>)entry.getValue()));
            }
            return json;
        }
    }
}

