/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.utils;

import com.almostreliable.unified.api.unification.UnificationEntry;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.Nullable;

public class VanillaTagWrapper<T> {
    private final Registry<T> registry;
    private final Map<ResourceLocation, Collection<Holder<T>>> vanillaTags;
    @Nullable
    private Map<Holder<T>, Set<ResourceLocation>> holdersToTags;
    private final Set<ResourceLocation> modifiedTags = new HashSet<ResourceLocation>();

    public static <T> VanillaTagWrapper<T> of(Registry<T> registry, Map<ResourceLocation, Collection<Holder<T>>> vanillaTags) {
        return new VanillaTagWrapper<T>(registry, vanillaTags);
    }

    public VanillaTagWrapper(Registry<T> registry, Map<ResourceLocation, Collection<Holder<T>>> vanillaTags) {
        this.registry = registry;
        this.vanillaTags = vanillaTags;
    }

    public void add(ResourceLocation tag, Holder<T> holder) {
        if (this.modifiedTags.contains(tag)) {
            this.vanillaTags.get(tag).add(holder);
            return;
        }
        Collection<Holder<T>> existingHolders = this.vanillaTags.get(tag);
        HashSet<Holder<T>> newHolders = existingHolders == null ? new HashSet<Holder<T>>() : new HashSet<Holder<T>>(existingHolders);
        newHolders.add(holder);
        this.vanillaTags.put(tag, newHolders);
        this.modifiedTags.add(tag);
    }

    public boolean has(TagKey<T> tag) {
        return this.vanillaTags.containsKey(tag.location());
    }

    public Collection<Holder<T>> get(TagKey<T> tag) {
        return Collections.unmodifiableCollection(this.vanillaTags.getOrDefault(tag.location(), Collections.emptyList()));
    }

    public Collection<Holder<T>> get(ResourceLocation tag) {
        return Collections.unmodifiableCollection(this.vanillaTags.getOrDefault(tag, Collections.emptyList()));
    }

    public Set<ResourceLocation> getTags(ResourceLocation entryId) {
        ResourceKey key = ResourceKey.create((ResourceKey)this.registry.key(), (ResourceLocation)entryId);
        return this.registry.getHolder(key).map(this::getTags).orElse(Set.of());
    }

    public Set<ResourceLocation> getTags(UnificationEntry<T> entry) {
        return this.getTags((Holder<T>)entry.asHolderOrThrow());
    }

    public Set<ResourceLocation> getTags(Holder<T> holder) {
        if (this.holdersToTags == null) {
            this.holdersToTags = this.createInvertMap();
        }
        return this.holdersToTags.getOrDefault(holder, Set.of());
    }

    private Map<Holder<T>, Set<ResourceLocation>> createInvertMap() {
        HashMap<Holder<T>, Set<ResourceLocation>> map = new HashMap<Holder<T>, Set<ResourceLocation>>();
        for (Map.Entry<ResourceLocation, Collection<Holder<T>>> entry : this.vanillaTags.entrySet()) {
            for (Holder<T> holder : entry.getValue()) {
                map.putIfAbsent(holder, new HashSet());
                ((Set)map.get(holder)).add(entry.getKey());
            }
        }
        return map;
    }

    public void seal() {
        for (ResourceLocation modifiedTag : this.modifiedTags) {
            Collection<Holder<T>> holders = this.vanillaTags.get(modifiedTag);
            if (holders == null) continue;
            this.vanillaTags.put(modifiedTag, List.copyOf(holders));
        }
        this.modifiedTags.clear();
        this.holdersToTags = null;
    }
}

