/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.client.model;

import com.buuz135.functionalstorage.util.Utils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import net.neoforged.neoforge.common.util.INBTSerializable;

public class FramedDrawerModelData
implements INBTSerializable<CompoundTag> {
    public static final ModelProperty<FramedDrawerModelData> FRAMED_PROPERTY = new ModelProperty();
    private Map<String, Item> design;
    private String code = "";

    public FramedDrawerModelData(Map<String, Item> design) {
        this.design = design;
        this.generateCode();
    }

    public Map<String, Item> getDesign() {
        return this.design;
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag compoundTag = new CompoundTag();
        this.design.forEach((s, item) -> compoundTag.putString(s, BuiltInRegistries.ITEM.getKey(item).toString()));
        return compoundTag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.design = new HashMap<String, Item>();
        for (String allKey : nbt.getAllKeys()) {
            this.design.put(allKey, (Item)BuiltInRegistries.ITEM.get(Utils.resourceLocation(nbt.getString(allKey))));
        }
        this.generateCode();
    }

    private void generateCode() {
        this.code = "";
        this.design.forEach((s, item) -> {
            this.code = this.code + s + String.valueOf(BuiltInRegistries.ITEM.getKey(item));
        });
    }

    public String getCode() {
        return this.code;
    }
}

