/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.item.component;

import com.buuz135.functionalstorage.block.config.FunctionalStorageConfig;
import com.buuz135.functionalstorage.block.tile.ControllableDrawerTile;
import com.buuz135.functionalstorage.block.tile.FluidDrawerTile;
import com.buuz135.functionalstorage.fluid.BigFluidHandler;
import com.buuz135.functionalstorage.item.UpgradeItem;
import com.buuz135.functionalstorage.item.component.FunctionalUpgradeBehavior;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public record MoveFluidsBehavior(boolean drawerIsSource, int fluidPerOperation) implements FunctionalUpgradeBehavior
{
    public static final MapCodec<MoveFluidsBehavior> CODEC = RecordCodecBuilder.mapCodec(in -> in.group((App)Codec.BOOL.fieldOf("drawer_is_source").forGetter(MoveFluidsBehavior::drawerIsSource), (App)Codec.INT.fieldOf("fluid_per_operation").forGetter(MoveFluidsBehavior::fluidPerOperation)).apply((Applicative)in, MoveFluidsBehavior::new));

    @Override
    public void work(Level level, BlockPos pos, ControllableDrawerTile<?> dr, ItemStack upgradeStack, int upgradeSlot) {
        block5: {
            if (!(dr instanceof FluidDrawerTile)) {
                return;
            }
            FluidDrawerTile drawer = (FluidDrawerTile)dr;
            Direction direction = UpgradeItem.getDirection(upgradeStack);
            IFluidHandler otherFluidHandler = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, pos.relative(direction), (Object)direction.getOpposite());
            if (otherFluidHandler == null) break block5;
            if (this.drawerIsSource) {
                for (int tankId = 0; tankId < drawer.getFluidHandler().getTanks(); ++tankId) {
                    int insertedAmount;
                    FluidStack extracted;
                    BigFluidHandler.CustomFluidTank fluidTank = drawer.fluidHandler.getTankList()[tankId];
                    if (fluidTank.getFluid().isEmpty() || (extracted = fluidTank.drain(FunctionalStorageConfig.UPGRADE_PUSH_FLUID, IFluidHandler.FluidAction.SIMULATE)).isEmpty() || (insertedAmount = otherFluidHandler.fill(extracted, IFluidHandler.FluidAction.EXECUTE)) <= 0) continue;
                    fluidTank.drain(insertedAmount, IFluidHandler.FluidAction.EXECUTE);
                    drawer.fluidHandler.onChange();
                    break;
                }
            } else {
                for (int tankId = 0; tankId < drawer.getFluidHandler().getTanks(); ++tankId) {
                    int insertedAmount;
                    BigFluidHandler.CustomFluidTank fluidTank = drawer.fluidHandler.getTankList()[tankId];
                    FluidStack extracted = otherFluidHandler.drain(FunctionalStorageConfig.UPGRADE_PULL_FLUID, IFluidHandler.FluidAction.SIMULATE);
                    if (extracted.isEmpty() || (insertedAmount = fluidTank.fill(extracted, IFluidHandler.FluidAction.EXECUTE)) <= 0) continue;
                    otherFluidHandler.drain(insertedAmount, IFluidHandler.FluidAction.EXECUTE);
                    drawer.fluidHandler.onChange();
                    break;
                }
            }
        }
    }

    @Override
    public MapCodec<? extends FunctionalUpgradeBehavior> codec() {
        return CODEC;
    }
}

