/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.data;

import de.ellpeck.actuallyadditions.api.ActuallyTags;
import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.config.conditions.BoolConfigCondition;
import de.ellpeck.actuallyadditions.mod.crafting.RecipeKeepDataShaped;
import de.ellpeck.actuallyadditions.mod.crafting.RecipeKeepDataShapeless;
import de.ellpeck.actuallyadditions.mod.crafting.TargetComponentIngredient;
import de.ellpeck.actuallyadditions.mod.items.ActuallyItems;
import de.ellpeck.actuallyadditions.mod.util.NoAdvRecipeOutput;
import de.ellpeck.actuallyadditions.mod.util.RecipeInjector;
import de.ellpeck.actuallyadditions.registration.AABlockReg;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;
import net.neoforged.neoforge.registries.DeferredItem;

public class ItemRecipeGenerator
extends RecipeProvider {
    public ItemRecipeGenerator(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(packOutput, lookupProvider);
    }

    @Nonnull
    public String getName() {
        return "Item " + super.getName();
    }

    protected void buildRecipes(@Nonnull RecipeOutput output, HolderLookup.Provider holderLookup) {
        HolderLookup.RegistryLookup enchantmentLookup = holderLookup.lookupOrThrow(Registries.ENCHANTMENT);
        NoAdvRecipeOutput recipeOutput = new NoAdvRecipeOutput(output);
        this.generateAOIT(recipeOutput);
        Recipe.shaped((ItemLike)ActuallyItems.ENGINEERS_GOGGLES.get()).pattern(" R ").pattern("IGI").define(Character.valueOf('R'), (ItemLike)ActuallyItems.RESTONIA_CRYSTAL.get()).define(Character.valueOf('I'), (ItemLike)Items.IRON_BARS).define(Character.valueOf('G'), Tags.Items.GLASS_BLOCKS).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyItems.ENGINEERS_GOGGLES_ADVANCED.get()).pattern(" R ").pattern("IGI").define(Character.valueOf('R'), (ItemLike)ActuallyItems.EMPOWERED_RESTONIA_CRYSTAL.get()).define(Character.valueOf('I'), (ItemLike)Items.IRON_BARS).define(Character.valueOf('G'), (ItemLike)ActuallyItems.ENGINEERS_GOGGLES.get()).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyItems.LASER_UPGRADE_INVISIBILITY.get(), 4).pattern("GGG").pattern("RCR").pattern("GGG").define(Character.valueOf('G'), (ItemLike)Items.BLACK_STAINED_GLASS).define(Character.valueOf('R'), (ItemLike)ActuallyItems.VOID_CRYSTAL.get()).define(Character.valueOf('C'), (ItemLike)ActuallyItems.ADVANCED_COIL.get()).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyItems.LASER_UPGRADE_RANGE.get(), 2).pattern("GGC").pattern("RCR").pattern("CGG").define(Character.valueOf('R'), (ItemLike)Items.COMPASS).define(Character.valueOf('G'), (ItemLike)ActuallyItems.RESTONIA_CRYSTAL.get()).define(Character.valueOf('C'), (ItemLike)ActuallyItems.ADVANCED_COIL.get()).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyItems.HANDHELD_FILLER.get()).pattern("IPI").pattern("DCD").pattern(" B ").define(Character.valueOf('I'), (ItemLike)ActuallyItems.EMPOWERED_ENORI_CRYSTAL.get()).define(Character.valueOf('P'), (ItemLike)ActuallyItems.PALIS_CRYSTAL.get()).define(Character.valueOf('C'), (ItemLike)ActuallyItems.ADVANCED_COIL.get()).define(Character.valueOf('D'), (ItemLike)ActuallyItems.DIAMATINE_CRYSTAL.get()).define(Character.valueOf('B'), (ItemLike)ActuallyItems.TRIPLE_BATTERY.get()).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyItems.TRAVELERS_SACK.get()).pattern("SLS").pattern("SCS").pattern("LVL").define(Character.valueOf('S'), Tags.Items.STRINGS).define(Character.valueOf('L'), Tags.Items.LEATHERS).define(Character.valueOf('C'), Tags.Items.CHESTS_WOODEN).define(Character.valueOf('V'), (ItemLike)ActuallyBlocks.VOID_CRYSTAL.getItem()).save((RecipeOutput)recipeOutput);
        Recipe.shapeless((ItemLike)ActuallyItems.VOID_SACK.get()).requires((ItemLike)ActuallyItems.TRAVELERS_SACK.get()).requires(Tags.Items.ENDER_PEARLS).requires(Tags.Items.OBSIDIANS).requires((ItemLike)ActuallyBlocks.VOID_CRYSTAL.getItem()).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyItems.LENS.get()).pattern("GGG").pattern("GBG").pattern("GGG").define(Character.valueOf('G'), Tags.Items.GLASS_BLOCKS).define(Character.valueOf('B'), (ItemLike)ActuallyItems.BLACK_QUARTZ.get()).save((RecipeOutput)recipeOutput);
        Recipe.shapeless((ItemLike)ActuallyItems.ITEM_BOOKLET.get()).ingredients(new ItemLike[]{(ItemLike)ActuallyItems.CANOLA_SEEDS.get(), Items.PAPER}).save(recipeOutput);
        Recipe.shapeless((ItemLike)ActuallyItems.LASER_WRENCH.get()).ingredients((ItemLike)ActuallyItems.LASER_WRENCH.get()).name(ActuallyAdditions.modLoc("laser_wrench_nbt")).save(recipeOutput);
        Recipe.shapeless((ItemLike)ActuallyItems.PHANTOM_CONNECTOR.get()).ingredients((ItemLike)ActuallyItems.PHANTOM_CONNECTOR.get()).name(ActuallyAdditions.modLoc("phantom_clearing")).save(recipeOutput);
        Recipe.shapeless((ItemLike)ActuallyItems.LENS_OF_DISENCHANTING.get()).requires((ItemLike)ActuallyItems.LENS.get()).requires((ItemLike)Items.ENCHANTING_TABLE).requires((ItemLike)ActuallyItems.EMPOWERED_DIAMATINE_CRYSTAL.get(), 7).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyItems.LENS_OF_THE_MINER.get()).pattern("DGI").pattern("CLB").pattern("QPE").define(Character.valueOf('D'), Tags.Items.GEMS_DIAMOND).define(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('C'), ItemTags.COALS).define(Character.valueOf('L'), (ItemLike)ActuallyItems.LENS.get()).define(Character.valueOf('B'), (ItemLike)ActuallyItems.BLACK_QUARTZ.get()).define(Character.valueOf('Q'), Tags.Items.GEMS_QUARTZ).define(Character.valueOf('P'), Tags.Items.GEMS_LAPIS).define(Character.valueOf('E'), Tags.Items.GEMS_EMERALD).save((RecipeOutput)recipeOutput);
        ItemStack enchantedBook = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
        enchantedBook.enchant((Holder)enchantmentLookup.getOrThrow(Enchantments.SHARPNESS), 5);
        Recipe.shapeless((ItemLike)ActuallyItems.LENS_OF_THE_KILLER.get()).requires((ItemLike)Items.DIAMOND_SWORD).requires((ItemLike)ActuallyItems.LENS_OF_CERTAIN_DEATH.get()).requires(DataComponentIngredient.of((boolean)true, (ItemStack)enchantedBook)).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyItems.FILTER.get()).pattern("III").pattern("IQI").pattern("III").define(Character.valueOf('I'), (ItemLike)Items.IRON_BARS).define(Character.valueOf('Q'), (ItemLike)ActuallyItems.BLACK_QUARTZ.get()).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyItems.CRATE_KEEPER.get()).pattern("WIW").pattern("IQI").pattern("WIW").define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('W'), ItemTags.PLANKS).define(Character.valueOf('Q'), (ItemLike)ActuallyItems.BLACK_QUARTZ.get()).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyItems.LASER_WRENCH.get()).pattern("C  ").pattern(" S ").pattern("  S").define(Character.valueOf('C'), (ItemLike)ActuallyItems.ADVANCED_COIL.get()).define(Character.valueOf('S'), (ItemLike)ActuallyItems.ENORI_CRYSTAL.get()).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)Items.PAPER, 3).pattern("R  ").pattern(" R ").pattern("  R").define(Character.valueOf('R'), ActuallyItems.RICE).save((RecipeOutput)recipeOutput, ActuallyAdditions.modLoc("rice_paper"));
        Recipe.shaped((ItemLike)ActuallyItems.RICE_SLIMEBALL.get()).requiresBook().pattern(" R ").pattern("RBR").pattern(" R ").define(Character.valueOf('R'), (ItemLike)ActuallyItems.RICE_DOUGH.get()).define(Character.valueOf('B'), (ItemLike)Items.WATER_BUCKET).save((RecipeOutput)recipeOutput, ActuallyAdditions.modLoc("rice_slime"));
        Recipe.shaped((ItemLike)ActuallyItems.RICE_SLIMEBALL.get()).requiresBook().pattern(" R ").pattern("RBR").pattern(" R ").define(Character.valueOf('R'), (ItemLike)ActuallyItems.RICE_DOUGH.get()).define(Character.valueOf('B'), (ItemLike)Items.POTION).save((RecipeOutput)recipeOutput, ActuallyAdditions.modLoc("rice_slime_potion"));
        Recipe.shaped((ItemLike)ActuallyItems.LEAF_BLOWER.get()).pattern(" F").pattern("IP").pattern("IC").define(Character.valueOf('I'), (ItemLike)ActuallyItems.ENORI_CRYSTAL.get()).define(Character.valueOf('P'), (ItemLike)Items.PISTON).define(Character.valueOf('F'), (ItemLike)Items.FLINT).define(Character.valueOf('C'), (ItemLike)ActuallyItems.ADVANCED_COIL.get()).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyItems.ADVANCED_LEAF_BLOWER.get()).pattern(" F", "DP", "DC").define(Character.valueOf('F'), (ItemLike)Items.FLINT).define(Character.valueOf('D'), (ItemLike)ActuallyItems.DIAMATINE_CRYSTAL.get()).define(Character.valueOf('P'), (ItemLike)Items.PISTON).define(Character.valueOf('C'), (ItemLike)ActuallyItems.ADVANCED_COIL.get()).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyItems.DRILL_MAIN.get()).pattern("DDD").pattern("CRC").pattern("III").define(Character.valueOf('D'), Tags.Items.GEMS_DIAMOND).define(Character.valueOf('C'), (ItemLike)ActuallyItems.ADVANCED_COIL.get()).define(Character.valueOf('R'), (ItemLike)ActuallyItems.DRILL_CORE.get()).define(Character.valueOf('I'), (ItemLike)ActuallyItems.ENORI_CRYSTAL.get()).save((RecipeOutput)recipeOutput);
        ItemRecipeGenerator.dyeDrill(ActuallyItems.DRILL_BLACK, (TagKey<Item>)Tags.Items.DYES_BLACK, recipeOutput);
        ItemRecipeGenerator.dyeDrill(ActuallyItems.DRILL_RED, (TagKey<Item>)Tags.Items.DYES_RED, recipeOutput);
        ItemRecipeGenerator.dyeDrill(ActuallyItems.DRILL_GREEN, (TagKey<Item>)Tags.Items.DYES_GREEN, recipeOutput);
        ItemRecipeGenerator.dyeDrill(ActuallyItems.DRILL_BROWN, (TagKey<Item>)Tags.Items.DYES_BROWN, recipeOutput);
        ItemRecipeGenerator.dyeDrill(ActuallyItems.DRILL_BLUE, (TagKey<Item>)Tags.Items.DYES_BLUE, recipeOutput);
        ItemRecipeGenerator.dyeDrill(ActuallyItems.DRILL_PURPLE, (TagKey<Item>)Tags.Items.DYES_PURPLE, recipeOutput);
        ItemRecipeGenerator.dyeDrill(ActuallyItems.DRILL_CYAN, (TagKey<Item>)Tags.Items.DYES_CYAN, recipeOutput);
        ItemRecipeGenerator.dyeDrill(ActuallyItems.DRILL_LIGHT_GRAY, (TagKey<Item>)Tags.Items.DYES_LIGHT_GRAY, recipeOutput);
        ItemRecipeGenerator.dyeDrill(ActuallyItems.DRILL_GRAY, (TagKey<Item>)Tags.Items.DYES_GRAY, recipeOutput);
        ItemRecipeGenerator.dyeDrill(ActuallyItems.DRILL_PINK, (TagKey<Item>)Tags.Items.DYES_PINK, recipeOutput);
        ItemRecipeGenerator.dyeDrill(ActuallyItems.DRILL_LIME, (TagKey<Item>)Tags.Items.DYES_LIME, recipeOutput);
        ItemRecipeGenerator.dyeDrill(ActuallyItems.DRILL_YELLOW, (TagKey<Item>)Tags.Items.DYES_YELLOW, recipeOutput);
        ItemRecipeGenerator.dyeDrill(ActuallyItems.DRILL_MAIN, (TagKey<Item>)Tags.Items.DYES_LIGHT_BLUE, recipeOutput);
        ItemRecipeGenerator.dyeDrill(ActuallyItems.DRILL_ORANGE, (TagKey<Item>)Tags.Items.DYES_ORANGE, recipeOutput);
        ItemRecipeGenerator.dyeDrill(ActuallyItems.DRILL_WHITE, (TagKey<Item>)Tags.Items.DYES_WHITE, recipeOutput);
        ItemRecipeGenerator.dyeDrill(ActuallyItems.DRILL_MAGENTA, (TagKey<Item>)Tags.Items.DYES_MAGENTA, recipeOutput);
        Recipe.shaped((ItemLike)ActuallyItems.DRILL_CORE.get()).pattern("ICI").pattern("CRC").pattern("ICI").define(Character.valueOf('C'), (ItemLike)ActuallyItems.BASIC_COIL.get()).define(Character.valueOf('R'), (ItemLike)ActuallyItems.RESTONIA_CRYSTAL.get()).define(Character.valueOf('I'), (ItemLike)ActuallyItems.ENORI_CRYSTAL.get()).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyItems.TELEPORT_STAFF.get()).pattern(" FE").pattern(" S ").pattern("SB ").define(Character.valueOf('F'), (ItemLike)ActuallyItems.EMPOWERED_DIAMATINE_CRYSTAL.get()).define(Character.valueOf('E'), Tags.Items.ENDER_PEARLS).define(Character.valueOf('S'), (ItemLike)ActuallyBlocks.ENDER_CASING.getItem()).define(Character.valueOf('B'), (ItemLike)ActuallyItems.SINGLE_BATTERY.get()).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyItems.DRILL_UPGRADE_SPEED.get()).pattern("ISI").pattern("SRS").pattern("ISI").define(Character.valueOf('I'), (ItemLike)ActuallyItems.ENORI_CRYSTAL.get()).define(Character.valueOf('S'), (ItemLike)Items.SUGAR).define(Character.valueOf('R'), (ItemLike)ActuallyItems.RESTONIA_CRYSTAL.get()).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyItems.DRILL_UPGRADE_SPEED_II.get()).pattern("ISI").pattern("SRS").pattern("ISI").define(Character.valueOf('I'), (ItemLike)ActuallyItems.ENORI_CRYSTAL.get()).define(Character.valueOf('S'), (ItemLike)Items.SUGAR).define(Character.valueOf('R'), (ItemLike)Items.CAKE).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyItems.DRILL_UPGRADE_SPEED_III.get()).pattern("ISI").pattern("SRS").pattern("ISI").define(Character.valueOf('I'), (ItemLike)ActuallyItems.EMPOWERED_ENORI_CRYSTAL.get()).define(Character.valueOf('S'), (ItemLike)Items.SUGAR).define(Character.valueOf('R'), (ItemLike)ActuallyItems.EMPOWERED_DIAMATINE_CRYSTAL.get()).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyItems.DRILL_UPGRADE_FORTUNE.get()).pattern("ISI").pattern("SRS").pattern("ISI").define(Character.valueOf('I'), (ItemLike)Items.GLOWSTONE).define(Character.valueOf('S'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('R'), (ItemLike)ActuallyBlocks.EMPOWERED_DIAMATINE_CRYSTAL.getItem()).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyItems.DRILL_UPGRADE_FORTUNE_II.get()).pattern("ISI").pattern("SRS").pattern("ISI").define(Character.valueOf('I'), (ItemLike)Items.GLOWSTONE).define(Character.valueOf('S'), (ItemLike)ActuallyItems.EMPOWERED_RESTONIA_CRYSTAL.get()).define(Character.valueOf('R'), (ItemLike)ActuallyBlocks.ENDER_CASING.getItem()).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyItems.DRILL_UPGRADE_THREE_BY_THREE.get()).pattern("DID").pattern("ICI").pattern("DID").define(Character.valueOf('I'), (ItemLike)ActuallyItems.ENORI_CRYSTAL.get()).define(Character.valueOf('D'), (ItemLike)ActuallyItems.DIAMATINE_CRYSTAL.get()).define(Character.valueOf('C'), (ItemLike)ActuallyItems.BASIC_COIL.get()).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyItems.DRILL_UPGRADE_FIVE_BY_FIVE.get()).pattern("DID").pattern("ICI").pattern("DID").define(Character.valueOf('I'), (ItemLike)ActuallyItems.EMPOWERED_ENORI_CRYSTAL.get()).define(Character.valueOf('D'), (ItemLike)ActuallyItems.DIAMATINE_CRYSTAL.get()).define(Character.valueOf('C'), (ItemLike)ActuallyItems.ADVANCED_COIL.get()).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyItems.DRILL_UPGRADE_SILK_TOUCH.get()).pattern("DSD").pattern("SCS").pattern("DSD").define(Character.valueOf('D'), (ItemLike)ActuallyItems.EMERADIC_CRYSTAL.get()).define(Character.valueOf('S'), (ItemLike)ActuallyItems.DIAMATINE_CRYSTAL.get()).define(Character.valueOf('C'), (ItemLike)ActuallyItems.ADVANCED_COIL.get()).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyItems.DRILL_UPGRADE_BLOCK_PLACING.get()).pattern("CEC").pattern("RAR").pattern("CEC").define(Character.valueOf('C'), Tags.Items.COBBLESTONES).define(Character.valueOf('E'), (ItemLike)Items.PAPER).define(Character.valueOf('A'), (ItemLike)ActuallyItems.BASIC_COIL.get()).define(Character.valueOf('R'), (ItemLike)ActuallyItems.ENORI_CRYSTAL.get()).save((RecipeOutput)recipeOutput);
        Recipe.shapeless((ItemLike)ActuallyItems.ENDER_STAR.get()).ingredients(new ItemLike[]{Items.NETHER_STAR, Items.DRAGON_BREATH, (ItemLike)ActuallyItems.BLACK_QUARTZ.get(), Items.PRISMARINE_SHARD}).save(recipeOutput);
        Recipe.shaped((ItemLike)ActuallyItems.WINGS_OF_THE_BATS.get()).pattern("WNW").pattern("WDW").pattern("WNW").define(Character.valueOf('W'), (ItemLike)ActuallyItems.BATS_WING.get()).define(Character.valueOf('N'), (ItemLike)ActuallyBlocks.DIAMATINE_CRYSTAL.getItem()).define(Character.valueOf('D'), (ItemLike)ActuallyItems.ENDER_STAR.get()).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyItems.BASIC_COIL.get()).pattern(" R ").pattern("RIR").pattern(" R ").define(Character.valueOf('I'), (ItemLike)ActuallyItems.BLACK_QUARTZ.get()).define(Character.valueOf('R'), (ItemLike)ActuallyItems.RESTONIA_CRYSTAL.get()).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyItems.ADVANCED_COIL.get()).pattern("GGG").pattern("GCG").pattern("GGG").define(Character.valueOf('C'), (ItemLike)ActuallyItems.BASIC_COIL.get()).define(Character.valueOf('G'), (ItemLike)Items.GOLD_NUGGET).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyItems.SINGLE_BATTERY.get()).pattern(" R ").pattern("ICI").pattern("III").define(Character.valueOf('R'), (ItemLike)ActuallyItems.RESTONIA_CRYSTAL.get()).define(Character.valueOf('I'), (ItemLike)ActuallyItems.ENORI_CRYSTAL.get()).define(Character.valueOf('C'), (ItemLike)ActuallyItems.ADVANCED_COIL.get()).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyItems.DOUBLE_BATTERY.get()).pattern(" R ").pattern("ICI").pattern("III").define(Character.valueOf('R'), TargetComponentIngredient.of((ItemLike)ActuallyItems.SINGLE_BATTERY.get())).define(Character.valueOf('I'), (ItemLike)ActuallyItems.ENORI_CRYSTAL.get()).define(Character.valueOf('C'), (ItemLike)ActuallyItems.ADVANCED_COIL.get()).save(new RecipeInjector<ShapedRecipe>(recipeOutput, RecipeKeepDataShaped::new));
        Recipe.shaped((ItemLike)ActuallyItems.TRIPLE_BATTERY.get()).pattern(" R ").pattern("ICI").pattern("III").define(Character.valueOf('R'), TargetComponentIngredient.of((ItemLike)ActuallyItems.DOUBLE_BATTERY.get())).define(Character.valueOf('I'), (ItemLike)ActuallyItems.EMPOWERED_ENORI_CRYSTAL.get()).define(Character.valueOf('C'), (ItemLike)ActuallyItems.ADVANCED_COIL.get()).save(new RecipeInjector<ShapedRecipe>(recipeOutput, RecipeKeepDataShaped::new));
        Recipe.shaped((ItemLike)ActuallyItems.QUADRUPLE_BATTERY.get()).pattern(" R ").pattern("ICI").pattern("III").define(Character.valueOf('R'), TargetComponentIngredient.of((ItemLike)ActuallyItems.TRIPLE_BATTERY.get())).define(Character.valueOf('I'), (ItemLike)ActuallyItems.EMPOWERED_ENORI_CRYSTAL.get()).define(Character.valueOf('C'), (ItemLike)ActuallyItems.ADVANCED_COIL.get()).save(new RecipeInjector<ShapedRecipe>(recipeOutput, RecipeKeepDataShaped::new));
        Recipe.shaped((ItemLike)ActuallyItems.QUINTUPLE_BATTERY.get()).pattern(" R ").pattern("ICI").pattern("III").define(Character.valueOf('R'), TargetComponentIngredient.of((ItemLike)ActuallyItems.QUADRUPLE_BATTERY.get())).define(Character.valueOf('I'), (ItemLike)ActuallyItems.EMPOWERED_DIAMATINE_CRYSTAL.get()).define(Character.valueOf('C'), (ItemLike)ActuallyItems.ADVANCED_COIL.get()).save(new RecipeInjector<ShapedRecipe>(recipeOutput, RecipeKeepDataShaped::new));
        Recipe.shaped((ItemLike)ActuallyItems.RING_OF_MAGNETIZING.get()).pattern("RIB", "IOI", "BIR").define(Character.valueOf('R'), (ItemLike)ActuallyItems.RESTONIA_CRYSTAL.get()).define(Character.valueOf('I'), (ItemLike)ActuallyItems.ENORI_CRYSTAL.get()).define(Character.valueOf('B'), (ItemLike)Items.LAPIS_LAZULI).define(Character.valueOf('O'), (ItemLike)ActuallyItems.RING.get()).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyItems.RING_OF_GROWTH.get()).pattern("SIS", "IOI", "SIS").define(Character.valueOf('S'), Tags.Items.SEEDS).define(Character.valueOf('I'), (ItemLike)ActuallyItems.EMPOWERED_ENORI_CRYSTAL.get()).define(Character.valueOf('O'), (ItemLike)ActuallyItems.RING.get()).save((RecipeOutput)recipeOutput);
        Recipe.shapeless((ItemLike)ActuallyItems.CRAFTER_ON_A_STICK.get()).requires((ItemLike)Items.CRAFTING_TABLE).requires(ItemTags.SIGNS).save((RecipeOutput)recipeOutput);
        RecipeOutput boolConsumer = recipeOutput.withConditions(new ICondition[]{new BoolConfigCondition("tinyCoalStuff")});
        Recipe.shapeless((ItemLike)ActuallyItems.TINY_COAL.get(), 8).requires((ItemLike)Items.COAL).save(boolConsumer, ActuallyAdditions.modLoc("coal_to_tiny"));
        Recipe.shapeless((ItemLike)ActuallyItems.TINY_CHARCOAL.get(), 8).requires((ItemLike)Items.CHARCOAL).save(boolConsumer, ActuallyAdditions.modLoc("charcoal_to_tiny"));
        Recipe.shaped((ItemLike)Items.COAL).pattern("CCC", "C C", "CCC").define(Character.valueOf('C'), (ItemLike)ActuallyItems.TINY_COAL.get()).save(boolConsumer, ActuallyAdditions.modLoc("tiny_to_coal"));
        Recipe.shaped((ItemLike)Items.CHARCOAL).pattern("CCC", "C C", "CCC").define(Character.valueOf('C'), (ItemLike)ActuallyItems.TINY_CHARCOAL.get()).save(boolConsumer, ActuallyAdditions.modLoc("tiny_to_charcoal"));
        Recipe.shapeless((ItemLike)ActuallyItems.CANOLA_SEEDS.get()).requires((ItemLike)ActuallyItems.CANOLA.get()).save((RecipeOutput)recipeOutput);
        Recipe.shapeless((ItemLike)ActuallyItems.RICE_SEEDS.get()).requires((ItemLike)ActuallyItems.RICE.get()).save((RecipeOutput)recipeOutput);
        Recipe.shapeless((ItemLike)ActuallyItems.RICE_DOUGH.get(), 2).requires((ItemLike)ActuallyItems.RICE.get(), 3).save((RecipeOutput)recipeOutput);
        Recipe.shaped(ActuallyItems.RING).pattern("IGI", "GDG", "IGI").define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('D'), Tags.Items.DUSTS_GLOWSTONE).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyItems.EMPTY_CUP.get()).pattern("S S", "SCS", "SSS").define(Character.valueOf('S'), Tags.Items.STONES).define(Character.valueOf('C'), (ItemLike)ActuallyItems.COFFEE_BEANS.get()).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyItems.PHANTOM_CONNECTOR.get()).pattern("YE", "EY", "S ").define(Character.valueOf('Y'), (ItemLike)Items.ENDER_EYE).define(Character.valueOf('E'), Tags.Items.ENDER_PEARLS).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyItems.PLAYER_PROBE.get()).pattern("A A", "AIA", "RHR").define(Character.valueOf('A'), (ItemLike)Items.IRON_BARS).define(Character.valueOf('R'), (ItemLike)ActuallyItems.EMPOWERED_RESTONIA_CRYSTAL.get()).define(Character.valueOf('H'), (ItemLike)Items.WITHER_SKELETON_SKULL).define(Character.valueOf('I'), (ItemLike)Items.IRON_HELMET).save((RecipeOutput)recipeOutput);
        Recipe.shapeless((ItemLike)ActuallyItems.ITEM_TAG.get()).requires((ItemLike)Items.PAPER).requires(ActuallyItems.BLACK_QUARTZ).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)Items.STICKY_PISTON).pattern("R", "P").define(Character.valueOf('R'), Tags.Items.SLIME_BALLS).define(Character.valueOf('P'), (ItemLike)Items.PISTON).save((RecipeOutput)recipeOutput, ActuallyAdditions.modLoc("tagged_sticky_piston"));
        Recipe.shaped((ItemLike)Items.SLIME_BLOCK).pattern("RRR", "RRR", "RRR").define(Character.valueOf('R'), Tags.Items.SLIME_BALLS).save((RecipeOutput)recipeOutput, ActuallyAdditions.modLoc("tagged_slime_block"));
        ItemRecipeGenerator.addShard(recipeOutput, ActuallyItems.VOID_CRYSTAL_SHARD, ActuallyItems.VOID_CRYSTAL);
        ItemRecipeGenerator.addShard(recipeOutput, ActuallyItems.ENORI_CRYSTAL_SHARD, ActuallyItems.ENORI_CRYSTAL);
        ItemRecipeGenerator.addShard(recipeOutput, ActuallyItems.RESTONIA_CRYSTAL_SHARD, ActuallyItems.RESTONIA_CRYSTAL);
        ItemRecipeGenerator.addShard(recipeOutput, ActuallyItems.PALIS_CRYSTAL_SHARD, ActuallyItems.PALIS_CRYSTAL);
        ItemRecipeGenerator.addShard(recipeOutput, ActuallyItems.DIAMATINE_CRYSTAL_SHARD, ActuallyItems.DIAMATINE_CRYSTAL);
        ItemRecipeGenerator.addShard(recipeOutput, ActuallyItems.EMERADIC_CRYSTAL_SHARD, ActuallyItems.EMERADIC_CRYSTAL);
        ItemRecipeGenerator.addCrystalBlock(recipeOutput, (ItemLike)ActuallyBlocks.VOID_CRYSTAL.getItem(), ActuallyItems.VOID_CRYSTAL);
        ItemRecipeGenerator.addCrystalBlock(recipeOutput, (ItemLike)ActuallyBlocks.ENORI_CRYSTAL.getItem(), ActuallyItems.ENORI_CRYSTAL);
        ItemRecipeGenerator.addCrystalBlock(recipeOutput, (ItemLike)ActuallyBlocks.RESTONIA_CRYSTAL.getItem(), ActuallyItems.RESTONIA_CRYSTAL);
        ItemRecipeGenerator.addCrystalBlock(recipeOutput, (ItemLike)ActuallyBlocks.PALIS_CRYSTAL.getItem(), ActuallyItems.PALIS_CRYSTAL);
        ItemRecipeGenerator.addCrystalBlock(recipeOutput, (ItemLike)ActuallyBlocks.DIAMATINE_CRYSTAL.getItem(), ActuallyItems.DIAMATINE_CRYSTAL);
        ItemRecipeGenerator.addCrystalBlock(recipeOutput, (ItemLike)ActuallyBlocks.EMERADIC_CRYSTAL.getItem(), ActuallyItems.EMERADIC_CRYSTAL);
        ItemRecipeGenerator.addCrystalBlock(recipeOutput, (ItemLike)ActuallyBlocks.EMPOWERED_VOID_CRYSTAL.getItem(), ActuallyItems.EMPOWERED_VOID_CRYSTAL);
        ItemRecipeGenerator.addCrystalBlock(recipeOutput, (ItemLike)ActuallyBlocks.EMPOWERED_ENORI_CRYSTAL.getItem(), ActuallyItems.EMPOWERED_ENORI_CRYSTAL);
        ItemRecipeGenerator.addCrystalBlock(recipeOutput, (ItemLike)ActuallyBlocks.EMPOWERED_RESTONIA_CRYSTAL.getItem(), ActuallyItems.EMPOWERED_RESTONIA_CRYSTAL);
        ItemRecipeGenerator.addCrystalBlock(recipeOutput, (ItemLike)ActuallyBlocks.EMPOWERED_PALIS_CRYSTAL.getItem(), ActuallyItems.EMPOWERED_PALIS_CRYSTAL);
        ItemRecipeGenerator.addCrystalBlock(recipeOutput, (ItemLike)ActuallyBlocks.EMPOWERED_DIAMATINE_CRYSTAL.getItem(), ActuallyItems.EMPOWERED_DIAMATINE_CRYSTAL);
        ItemRecipeGenerator.addCrystalBlock(recipeOutput, (ItemLike)ActuallyBlocks.EMPOWERED_EMERADIC_CRYSTAL.getItem(), ActuallyItems.EMPOWERED_EMERADIC_CRYSTAL);
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ActuallyItems.RICE_DOUGH}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)Items.BREAD, (float)0.35f, (int)200).unlockedBy("", ItemRecipeGenerator.has((ItemLike)Items.AIR)).save((RecipeOutput)recipeOutput, ActuallyAdditions.modLoc("rice_dough_smelting"));
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ActuallyBlocks.BLACK_QUARTZ_ORE.getItem()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ActuallyItems.BLACK_QUARTZ.get()), (float)0.7f, (int)200).unlockedBy("", ItemRecipeGenerator.has((ItemLike)Items.AIR)).save((RecipeOutput)recipeOutput, ActuallyAdditions.modLoc("black_quartz_ore_smelting"));
        SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ActuallyBlocks.BLACK_QUARTZ_ORE.getItem()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ActuallyItems.BLACK_QUARTZ.get()), (float)0.7f, (int)100).unlockedBy("", ItemRecipeGenerator.has((ItemLike)Items.AIR)).save((RecipeOutput)recipeOutput, ActuallyAdditions.modLoc("black_quartz_ore_blasting"));
        Recipe.shapeless((ItemLike)ActuallyItems.DRILL_PATTERN.get()).requires((ItemLike)ActuallyItems.DRILL_CORE.get()).requires((ItemLike)Items.PAPER).save((RecipeOutput)recipeOutput);
        Recipe.shapeless((ItemLike)ActuallyItems.LEAF_BLO_PATTERN.get()).requires((ItemLike)ActuallyItems.LEAF_BLOWER.get()).requires((ItemLike)Items.PAPER).save((RecipeOutput)recipeOutput);
        Recipe.shapeless((ItemLike)ActuallyItems.PHAN_CON_PATTERN.get()).requires((ItemLike)ActuallyItems.PHANTOM_CONNECTOR.get()).requires((ItemLike)Items.PAPER).save((RecipeOutput)recipeOutput);
        Recipe.shapeless((ItemLike)ActuallyItems.BOOK_PATTERN.get()).requires((ItemLike)ActuallyItems.ITEM_BOOKLET.get()).requires((ItemLike)Items.PAPER).save((RecipeOutput)recipeOutput);
        this.generateReset(ActuallyBlocks.OIL_GENERATOR, recipeOutput);
        this.generateReset(ActuallyBlocks.COAL_GENERATOR, recipeOutput);
        this.generateReset(ActuallyBlocks.LEAF_GENERATOR, recipeOutput);
        this.generateReset(ActuallyBlocks.POWERED_FURNACE, recipeOutput);
        this.generateReset(ActuallyBlocks.CRUSHER, recipeOutput);
        this.generateReset(ActuallyBlocks.CRUSHER_DOUBLE, recipeOutput);
        this.generateReset(ActuallyBlocks.DISPLAY_STAND, recipeOutput);
        this.generateReset(ActuallyBlocks.ATOMIC_RECONSTRUCTOR, recipeOutput);
        this.generateReset(ActuallyBlocks.FARMER, recipeOutput);
        this.generateReset(ActuallyBlocks.DROPPER, recipeOutput);
        this.generateReset(ActuallyBlocks.PLACER, recipeOutput);
        this.generateReset(ActuallyBlocks.BREAKER, recipeOutput);
        this.generateReset(ActuallyBlocks.FLUID_COLLECTOR, recipeOutput);
        this.generateReset(ActuallyBlocks.FLUID_PLACER, recipeOutput);
        this.generateReset(ActuallyBlocks.COFFEE_MACHINE, recipeOutput);
        this.generateReset(ActuallyBlocks.CANOLA_PRESS, recipeOutput);
        this.generateReset(ActuallyBlocks.FERMENTING_BARREL, recipeOutput);
    }

    protected void generateReset(@Nonnull AABlockReg<?, ?, ?> item, @Nonnull RecipeOutput consumer) {
        Recipe.shapeless(item.getItem()).ingredients(new ItemLike[]{item.getItem()}).name(ActuallyAdditions.modLoc("reset/" + item.getName())).save(consumer);
    }

    protected void generateAOIT(RecipeOutput consumer) {
        ItemRecipeGenerator.addPaxel(consumer, ActuallyItems.WOODEN_AIOT, Items.WOODEN_AXE, Items.WOODEN_PICKAXE, Items.WOODEN_SWORD, Items.WOODEN_SHOVEL, Items.WOODEN_HOE);
        ItemRecipeGenerator.addPaxel(consumer, ActuallyItems.STONE_AIOT, Items.STONE_AXE, Items.STONE_PICKAXE, Items.STONE_SWORD, Items.STONE_SHOVEL, Items.STONE_HOE);
        ItemRecipeGenerator.addPaxel(consumer, ActuallyItems.IRON_AIOT, Items.IRON_AXE, Items.IRON_PICKAXE, Items.IRON_SWORD, Items.IRON_SHOVEL, Items.IRON_HOE);
        ItemRecipeGenerator.addPaxel(consumer, ActuallyItems.GOLD_AIOT, Items.GOLDEN_AXE, Items.GOLDEN_PICKAXE, Items.GOLDEN_SWORD, Items.GOLDEN_SHOVEL, Items.GOLDEN_HOE);
        ItemRecipeGenerator.addPaxel(consumer, ActuallyItems.DIAMOND_AIOT, Items.DIAMOND_AXE, Items.DIAMOND_PICKAXE, Items.DIAMOND_SWORD, Items.DIAMOND_SHOVEL, Items.DIAMOND_HOE);
        ItemRecipeGenerator.addPaxel(consumer, ActuallyItems.NETHERITE_AIOT, Items.NETHERITE_AXE, Items.NETHERITE_PICKAXE, Items.NETHERITE_SWORD, Items.NETHERITE_SHOVEL, Items.NETHERITE_HOE);
    }

    private static void dyeDrill(DeferredItem<? extends Item> result, TagKey<Item> dyeItem, RecipeOutput recipeOutput) {
        Recipe.shapeless((ItemLike)result.get()).requires(TargetComponentIngredient.of(ActuallyTags.Items.DRILLS)).requires(dyeItem).save(new RecipeInjector<ShapelessRecipe>(recipeOutput, RecipeKeepDataShapeless::new), ActuallyAdditions.modLoc("drill_coloring/dye_" + BuiltInRegistries.ITEM.getKey((Object)((Item)result.get())).getPath()));
    }

    public static void addPaxel(RecipeOutput consumer, DeferredItem<? extends Item> output, Item axe, Item pickaxe, Item sword, Item shovel, Item hoe) {
        Recipe.shapeless((ItemLike)output.get()).requires((ItemLike)axe).requires((ItemLike)pickaxe).requires((ItemLike)sword).requires((ItemLike)shovel).requires((ItemLike)hoe).save(consumer);
    }

    public static void addPaxel(RecipeOutput consumer, DeferredItem<? extends Item> output, DeferredItem<? extends Item> axe, DeferredItem<? extends Item> pickaxe, DeferredItem<? extends Item> sword, DeferredItem<? extends Item> shovel, DeferredItem<? extends Item> hoe) {
        Recipe.shapeless((ItemLike)output.get()).requires((ItemLike)axe.get()).requires((ItemLike)pickaxe.get()).requires((ItemLike)sword.get()).requires((ItemLike)shovel.get()).requires((ItemLike)hoe.get()).save(consumer);
    }

    public static void decompress(RecipeOutput consumer, ItemLike output, ItemLike input) {
        ResourceLocation key = BuiltInRegistries.ITEM.getKey((Object)output.asItem());
        Recipe.shapeless(output, 9).requires(input).save(consumer, ResourceLocation.fromNamespaceAndPath((String)key.getNamespace(), (String)("decompress/" + key.getPath())));
    }

    public static void compress(RecipeOutput consumer, ItemLike output, ItemLike input) {
        ResourceLocation key = BuiltInRegistries.ITEM.getKey((Object)output.asItem());
        Recipe.shaped(output).pattern("xxx", "xxx", "xxx").define(Character.valueOf('x'), input).save(consumer, ResourceLocation.fromNamespaceAndPath((String)key.getNamespace(), (String)("compress/" + key.getPath())));
    }

    public static void addShard(RecipeOutput consumer, DeferredItem<? extends Item> shard, DeferredItem<? extends Item> crystal) {
        ItemRecipeGenerator.compress(consumer, crystal, shard);
        ItemRecipeGenerator.decompress(consumer, shard, crystal);
    }

    public static void addCrystalBlock(RecipeOutput consumer, ItemLike block, DeferredItem<? extends Item> crystal) {
        ItemRecipeGenerator.compress(consumer, block, crystal);
        ItemRecipeGenerator.decompress(consumer, crystal, block);
    }

    public static void addToolAndArmorRecipes(RecipeOutput consumer, DeferredItem<? extends Item> base, DeferredItem<? extends Item> pickaxe, DeferredItem<? extends Item> sword, DeferredItem<? extends Item> axe, DeferredItem<? extends Item> shovel, DeferredItem<? extends Item> hoe, DeferredItem<? extends Item> helm, DeferredItem<? extends Item> chest, DeferredItem<? extends Item> pants, DeferredItem<? extends Item> boots) {
        Recipe.shaped((ItemLike)pickaxe.get()).pattern("EEE", " S ", " S ").define(Character.valueOf('E'), (ItemLike)base.get()).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).save(consumer);
        Recipe.shaped((ItemLike)sword.get()).pattern("E", "E", "S").define(Character.valueOf('E'), (ItemLike)base.get()).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).save(consumer);
        Recipe.shaped((ItemLike)axe.get()).pattern("EE", "ES", " S").define(Character.valueOf('E'), (ItemLike)base.get()).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).save(consumer);
        Recipe.shaped((ItemLike)shovel.get()).pattern("E", "S", "S").define(Character.valueOf('E'), (ItemLike)base.get()).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).save(consumer);
        Recipe.shaped((ItemLike)hoe.get()).pattern("EE", " S", " S").define(Character.valueOf('E'), (ItemLike)base.get()).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).save(consumer);
        Recipe.shaped((ItemLike)helm.get()).pattern("OOO", "O O").define(Character.valueOf('O'), (ItemLike)base.get()).save(consumer);
        Recipe.shaped((ItemLike)chest.get()).pattern("O O", "OOO", "OOO").define(Character.valueOf('O'), (ItemLike)base.get()).save(consumer);
        Recipe.shaped((ItemLike)pants.get()).pattern("OOO", "O O", "O O").define(Character.valueOf('O'), (ItemLike)base.get()).save(consumer);
        Recipe.shaped((ItemLike)boots.get()).pattern("O O", "O O").define(Character.valueOf('O'), (ItemLike)base.get()).save(consumer);
    }

    public static class Recipe {
        public static Shapeless shapeless(ItemLike result) {
            return new Shapeless(result);
        }

        public static Shapeless shapeless(ItemLike result, int count) {
            return new Shapeless(result, count);
        }

        public static Shaped shaped(ItemLike result) {
            return new Shaped(result);
        }

        public static Shaped shaped(ItemLike result, int count) {
            return new Shaped(result, count);
        }

        private static class Shapeless
        extends ShapelessRecipeBuilder {
            private ResourceLocation name;

            public Shapeless(ItemLike result) {
                this(result, 1);
            }

            public Shapeless(ItemLike result, int countIn) {
                super(RecipeCategory.MISC, result, countIn);
            }

            public Shapeless ingredients(ItemLike ... ingredients) {
                Arrays.asList(ingredients).forEach(arg_0 -> ((Shapeless)this).requires(arg_0));
                return this;
            }

            public Shapeless name(ResourceLocation name) {
                this.name = name;
                return this;
            }

            public void save(@Nonnull RecipeOutput consumer) {
                this.unlockedBy("has_book", ItemRecipeGenerator.has((ItemLike)((ItemLike)ActuallyItems.ITEM_BOOKLET.get())));
                if (this.name != null) {
                    this.save(consumer, this.name);
                } else {
                    super.save(consumer);
                }
            }

            public void save(@Nonnull RecipeOutput consumer, @Nonnull ResourceLocation location) {
                this.unlockedBy("", ItemRecipeGenerator.has((ItemLike)((ItemLike)Items.AIR)));
                super.save(consumer, location);
            }
        }

        public static class Shaped
        extends ShapedRecipeBuilder {
            public Shaped(ItemLike resultIn) {
                this(resultIn, 1);
            }

            public Shaped(ItemLike resultIn, int countIn) {
                super(RecipeCategory.MISC, resultIn, countIn);
            }

            public Shaped pattern(String line1, String line2, String line3) {
                this.pattern(line1);
                this.pattern(line2);
                this.pattern(line3);
                return this;
            }

            public Shaped pattern(String line1, String line2) {
                this.pattern(line1);
                this.pattern(line2);
                return this;
            }

            public Shaped patternSingleKey(char key, ItemLike resource, String ... lines) {
                this.define(Character.valueOf(key), resource);
                for (String line : lines) {
                    this.pattern(line);
                }
                return this;
            }

            public Shaped requiresBook() {
                this.unlockedBy("has_book", ItemRecipeGenerator.has((ItemLike)((ItemLike)ActuallyItems.ITEM_BOOKLET.get())));
                return this;
            }

            public void save(@Nonnull RecipeOutput consumerIn) {
                this.unlockedBy("has_book", ItemRecipeGenerator.has((ItemLike)((ItemLike)ActuallyItems.ITEM_BOOKLET.get())));
                super.save(consumerIn);
            }

            public void save(@Nonnull RecipeOutput consumer, @Nonnull ResourceLocation location) {
                this.unlockedBy("", ItemRecipeGenerator.has((ItemLike)((ItemLike)Items.AIR)));
                super.save(consumer, location);
            }
        }
    }
}

