/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.ellpeck.actuallyadditions.mod.crafting.ActuallyRecipes;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;

public class PressingRecipe
implements Recipe<RecipeInput> {
    public static final String NAME = "pressing";
    private final Ingredient input;
    private final FluidStack output;

    public PressingRecipe(Ingredient input, FluidStack output) {
        this.input = input;
        this.output = output;
    }

    public boolean matches(@Nonnull RecipeInput pInv, @Nullable Level pLevel) {
        return this.input.test(pInv.getItem(0));
    }

    public boolean isSpecial() {
        return true;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public ItemStack assemble(RecipeInput pInv, HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    public FluidStack getOutput() {
        return this.output;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return ActuallyRecipes.PRESSING_RECIPE.get();
    }

    public RecipeType<?> getType() {
        return ActuallyRecipes.Types.PRESSING.get();
    }

    public static class Serializer
    implements RecipeSerializer<PressingRecipe> {
        private static final MapCodec<PressingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(recipe -> recipe.input), (App)FluidStack.CODEC.fieldOf("fluid").forGetter(recipe -> recipe.output)).apply((Applicative)instance, PressingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, PressingRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<PressingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, PressingRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static PressingRecipe fromNetwork(@Nonnull RegistryFriendlyByteBuf pBuffer) {
            Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)pBuffer);
            FluidStack output = (FluidStack)FluidStack.STREAM_CODEC.decode((Object)pBuffer);
            return new PressingRecipe(ingredient, output);
        }

        public static void toNetwork(@Nonnull RegistryFriendlyByteBuf pBuffer, @Nonnull PressingRecipe pRecipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)pBuffer, (Object)pRecipe.input);
            FluidStack.STREAM_CODEC.encode((Object)pBuffer, (Object)pRecipe.output);
        }
    }
}

