/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items;

import de.ellpeck.actuallyadditions.api.ActuallyTags;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.context.UseOnContext;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;

public class AllInOneTool
extends DiggerItem {
    private static final List<ItemAbility> ACTIONS = List.of(ItemAbilities.AXE_DIG, ItemAbilities.HOE_DIG, ItemAbilities.PICKAXE_DIG, ItemAbilities.SHOVEL_DIG, ItemAbilities.HOE_TILL, ItemAbilities.SHOVEL_FLATTEN, ItemAbilities.AXE_STRIP);

    public AllInOneTool(Tier tier) {
        super(tier, ActuallyTags.Blocks.MINEABLE_WITH_AIO, new Item.Properties().durability(tier.getUses() * 4).component(DataComponents.TOOL, (Object)tier.createToolProperties(ActuallyTags.Blocks.MINEABLE_WITH_AIO)).attributes(AllInOneTool.createAttributes(tier)));
    }

    private static ItemAttributeModifiers createAttributes(Tier tier) {
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
        builder.add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, (double)(4.0f + tier.getAttackDamageBonus()), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        builder.add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, -2.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        return builder.build();
    }

    public boolean canPerformAction(@Nonnull ItemStack stack, @Nonnull ItemAbility toolAction) {
        if (ACTIONS.contains(toolAction)) {
            return true;
        }
        return super.canPerformAction(stack, toolAction);
    }

    @Nonnull
    public InteractionResult useOn(UseOnContext context) {
        if (context.getPlayer() == null) {
            return InteractionResult.FAIL;
        }
        if (context.getPlayer().isCrouching()) {
            return Items.IRON_SHOVEL.useOn(context);
        }
        InteractionResult tmp = Items.IRON_AXE.useOn(context);
        if (tmp == InteractionResult.SUCCESS) {
            return tmp;
        }
        return Items.IRON_HOE.useOn(context);
    }
}

