/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items;

import de.ellpeck.actuallyadditions.api.ActuallyTags;
import de.ellpeck.actuallyadditions.data.LootTableGenerator;
import de.ellpeck.actuallyadditions.mod.config.CommonConfig;
import de.ellpeck.actuallyadditions.mod.entity.EntityWorm;
import de.ellpeck.actuallyadditions.mod.entity.InitEntities;
import de.ellpeck.actuallyadditions.mod.items.base.ItemBase;
import de.ellpeck.actuallyadditions.mod.util.LootTableUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.event.level.BlockEvent;

public class Worm
extends ItemBase {
    public InteractionResult useOn(UseOnContext context) {
        BlockPos pos = context.getClickedPos();
        ItemStack stack = context.getItemInHand();
        Level level = context.getLevel();
        BlockState state = level.getBlockState(pos);
        if (level.isClientSide || !EntityWorm.canWormify(level, context.getClickedPos(), state)) {
            return super.useOn(context);
        }
        List worms = level.getEntitiesOfClass(EntityWorm.class, new AABB((double)(pos.getX() - 1), (double)pos.getY(), (double)(pos.getZ() - 1), (double)(pos.getX() + 2), (double)(pos.getY() + 1), (double)(pos.getZ() + 2)));
        if (!worms.isEmpty()) {
            return super.useOn(context);
        }
        EntityWorm worm = new EntityWorm(InitEntities.ENTITY_WORM.get(), level);
        worm.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
        worm.setCustomName(stack.getHoverName());
        level.addFreshEntity((Entity)worm);
        stack.consume(1, (LivingEntity)context.getPlayer());
        return InteractionResult.SUCCESS;
    }

    public static void onHoe(BlockEvent.BlockToolModificationEvent event) {
        LevelAccessor levelAccessor;
        if (event.getItemAbility() == ItemAbilities.HOE_TILL && (levelAccessor = event.getLevel()) instanceof Level) {
            BlockState state;
            Level level = (Level)levelAccessor;
            if (level.isClientSide || !((Boolean)CommonConfig.Other.WORMS.get()).booleanValue()) {
                return;
            }
            BlockPos pos = event.getContext().getClickedPos();
            if (level.isEmptyBlock(pos.above()) && (state = level.getBlockState(pos)).is(ActuallyTags.Blocks.WORM_CAN_POP)) {
                float luck = event.getPlayer() != null ? event.getPlayer().getLuck() : 0.0f;
                ObjectArrayList loot_worm_items = LootTableUtil.getLootFromTable(level, LootTableGenerator.ItemWorm.WORM_DROP.location()).getRandomItems(new LootParams.Builder((ServerLevel)event.getLevel()).withLuck(luck).create(LootContextParamSets.EMPTY));
                for (ItemStack item : loot_worm_items) {
                    level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX() + 0.5, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5, item));
                }
            }
        }
    }
}

