/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.network.packet;

import de.ellpeck.actuallyadditions.mod.items.ItemCrafterOnAStick;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record HotkeyPacket(HotKey hotKey) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<HotkeyPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"actuallyadditions", (String)"hotkey"));
    public static final StreamCodec<FriendlyByteBuf, HotkeyPacket> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BYTE, packet -> (byte)packet.hotKey.ordinal(), HotkeyPacket::new);

    public HotkeyPacket(byte type) {
        this(HotKey.values()[type]);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(HotkeyPacket packet, IPayloadContext ctx) {
        switch (packet.hotKey.ordinal()) {
            case 0: {
                ctx.enqueueWork(() -> HotkeyPacket.open(ctx));
            }
        }
    }

    private static void open(IPayloadContext ctx) {
        Player player = ctx.player();
        if (ItemCrafterOnAStick.hasCrafterOnAStick(player)) {
            ItemCrafterOnAStick.openCraftingMenu(player);
        }
    }

    public static enum HotKey {
        OPEN_CRAFTING_STICK;

    }
}

