/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.items.ItemBattery;
import de.ellpeck.actuallyadditions.mod.tile.ISharingEnergyProvider;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import de.ellpeck.actuallyadditions.mod.util.ItemUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class TileEntityBatteryBox
extends TileEntityInventoryBase
implements ISharingEnergyProvider {
    private int lastEnergyStored;
    private int lastCompare;

    public TileEntityBatteryBox(BlockPos pos, BlockState state) {
        super(ActuallyBlocks.BATTERY_BOX.getTileEntityType(), pos, state, 1);
    }

    @Override
    public IEnergyStorage getEnergyStorage(Direction facing) {
        ItemStack stack = this.inv.getStackInSlot(0);
        if (stack.getItem() instanceof ItemBattery) {
            return (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM, null);
        }
        return null;
    }

    public static <T extends BlockEntity> void clientTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityBatteryBox) {
            TileEntityBatteryBox tile = (TileEntityBatteryBox)t;
            tile.clientTick();
        }
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityBatteryBox) {
            TileEntityBatteryBox tile = (TileEntityBatteryBox)t;
            tile.serverTick();
            Optional<IEnergyStorage> cap = Optional.ofNullable(tile.getEnergyStorage(null));
            int currStorage = cap.map(storage -> {
                ItemStack stack = tile.inv.getStackInSlot(0);
                if (!stack.isEmpty() && ItemUtil.isEnabled(stack) && storage.getEnergyStored() > 0) {
                    ArrayList<TileEntityBatteryBox> tiles = new ArrayList<TileEntityBatteryBox>();
                    tile.energyPushOffLoop(tile, tiles);
                    if (!tiles.isEmpty()) {
                        int amount = tiles.size();
                        int energyPer = storage.getEnergyStored() / amount;
                        if (energyPer <= 0) {
                            energyPer = storage.getEnergyStored();
                        }
                        int maxPer = storage.extractEnergy(energyPer, true);
                        for (TileEntityBatteryBox te : tiles) {
                            ItemStack battery = te.inv.getStackInSlot(0);
                            if (battery.isEmpty() || ItemUtil.isEnabled(battery)) continue;
                            int received = Optional.ofNullable((IEnergyStorage)level.getCapability(Capabilities.EnergyStorage.BLOCK, te.getBlockPos(), null)).map(e -> e.receiveEnergy(maxPer, false)).orElse(0);
                            storage.extractEnergy(received, false);
                            if (storage.getEnergyStored() > 0) continue;
                            break;
                        }
                    }
                }
                return storage.getEnergyStored();
            }).orElse(0);
            if (tile.lastCompare != tile.getComparatorStrength()) {
                tile.lastCompare = tile.getComparatorStrength();
                tile.setChanged();
            }
            if (tile.lastEnergyStored != currStorage && tile.sendUpdateWithInterval()) {
                tile.lastEnergyStored = currStorage;
            }
        }
    }

    @Override
    public void serverTick() {
        super.serverTick();
    }

    @Override
    public int getComparatorStrength() {
        return Optional.ofNullable(this.getEnergyStorage(null)).map(cap -> (int)((float)cap.getEnergyStored() / (float)cap.getMaxEnergyStored() * 15.0f)).orElse(0);
    }

    @Override
    public boolean respondsToPulses() {
        return true;
    }

    @Override
    public void activateOnPulse() {
        ItemStack stack = this.inv.getStackInSlot(0);
        if (!stack.isEmpty()) {
            ItemUtil.changeEnabled(stack);
            this.setChanged();
        }
    }

    private void energyPushOffLoop(TileEntityBatteryBox startTile, List<TileEntityBatteryBox> pushOffTo) {
        if (pushOffTo.size() >= 15) {
            return;
        }
        for (BlockEntity tile : startTile.tilesAround) {
            TileEntityBatteryBox box;
            if (!(tile instanceof TileEntityBatteryBox) || pushOffTo.contains(box = (TileEntityBatteryBox)tile)) continue;
            pushOffTo.add(box);
            this.energyPushOffLoop(box, pushOffTo);
        }
    }

    @Override
    public ItemStackHandlerAA.IAcceptor getAcceptor() {
        return (slot, stack, automation) -> stack.getItem() instanceof ItemBattery;
    }

    @Override
    public boolean shouldSyncSlots() {
        return true;
    }

    @Override
    public int getEnergyToSplitShare() {
        return Optional.ofNullable(this.getEnergyStorage(null)).map(IEnergyStorage::getEnergyStored).orElse(0);
    }

    @Override
    public boolean doesShareEnergy() {
        return true;
    }

    @Override
    public Direction[] getEnergyShareSides() {
        return Direction.values();
    }

    @Override
    public boolean canShareTo(BlockEntity tile) {
        return !(tile instanceof TileEntityBatteryBox);
    }
}

