/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public abstract class TileEntityInventoryBase
extends TileEntityBase {
    public final ItemStackHandlerAA inv;

    public TileEntityInventoryBase(BlockEntityType<?> type, BlockPos pos, BlockState state, int slots) {
        super(type, pos, state);
        this.inv = new TileStackHandler(slots);
    }

    @Override
    public void writeSyncableNBT(CompoundTag compound, HolderLookup.Provider lookupProvider, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, lookupProvider, type);
        if (type == TileEntityBase.NBTType.SAVE_TILE || type == TileEntityBase.NBTType.SYNC && this.shouldSyncSlots()) {
            compound.put("Items", (Tag)this.inv.serializeNBT(lookupProvider));
        }
    }

    @Override
    public IItemHandler getItemHandler(Direction facing) {
        return this.inv;
    }

    public ItemStackHandlerAA.IAcceptor getAcceptor() {
        return ItemStackHandlerAA.ACCEPT_TRUE;
    }

    public ItemStackHandlerAA.IRemover getRemover() {
        return ItemStackHandlerAA.REMOVE_TRUE;
    }

    public int getMaxStackSize(int slot) {
        return 64;
    }

    public boolean shouldSyncSlots() {
        return false;
    }

    public void setChanged() {
        super.setChanged();
        if (this.shouldSyncSlots()) {
            this.sendUpdate();
        }
    }

    @Override
    public int getComparatorStrength() {
        return ItemHandlerHelper.calcRedstoneFromInventory((IItemHandler)this.inv);
    }

    @Override
    public void readSyncableNBT(CompoundTag compound, HolderLookup.Provider lookupProvider, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, lookupProvider, type);
        if (type == TileEntityBase.NBTType.SAVE_TILE || type == TileEntityBase.NBTType.SYNC && this.shouldSyncSlots()) {
            this.inv.deserializeNBT(lookupProvider, compound.getCompound("Items"));
        }
    }

    protected class TileStackHandler
    extends ItemStackHandlerAA {
        protected TileStackHandler(int slots) {
            super(slots);
        }

        @Override
        public ItemStackHandlerAA.IAcceptor getAcceptor() {
            return TileEntityInventoryBase.this.getAcceptor();
        }

        @Override
        public ItemStackHandlerAA.IRemover getRemover() {
            return TileEntityInventoryBase.this.getRemover();
        }

        public int getSlotLimit(int slot) {
            return TileEntityInventoryBase.this.getMaxStackSize(slot);
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            TileEntityInventoryBase.this.setChanged();
        }
    }
}

