/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.ironjetpacks.client.handler;

import com.blakebr0.cucumber.helper.VecHelper;
import com.blakebr0.ironjetpacks.client.sound.JetpackSound;
import com.blakebr0.ironjetpacks.config.ModConfigs;
import com.blakebr0.ironjetpacks.item.JetpackItem;
import com.blakebr0.ironjetpacks.registry.Jetpack;
import com.blakebr0.ironjetpacks.util.JetpackUtils;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;

public final class JetpackClientHandler {
    @SubscribeEvent
    public void onClientTick(ClientTickEvent.Pre event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null && mc.level != null && !mc.isPaused()) {
            ItemStack chest = JetpackUtils.getEquippedJetpack((Player)mc.player);
            Item item = chest.getItem();
            if (!chest.isEmpty() && item instanceof JetpackItem && JetpackUtils.isFlying((Player)mc.player)) {
                if (((Boolean)ModConfigs.ENABLE_JETPACK_PARTICLES.get()).booleanValue() && mc.options.particles().get() != ParticleStatus.MINIMAL) {
                    double[] dArray;
                    Jetpack jetpack = JetpackUtils.getJetpack(chest);
                    Vec3 playerPos = mc.player.position().add(0.0, 1.5, 0.0);
                    float random = (ThreadLocalRandom.current().nextFloat() - 0.5f) * 0.1f;
                    if (mc.player.isCrouching()) {
                        double[] dArray2 = new double[2];
                        dArray2[0] = -0.3;
                        dArray = dArray2;
                        dArray2[1] = -0.1;
                    } else {
                        double[] dArray3 = new double[2];
                        dArray3[0] = 0.0;
                        dArray = dArray3;
                        dArray3[1] = 0.0;
                    }
                    double[] sneakBonus = dArray;
                    Vec3 vLeft = VecHelper.rotate((Vec3)new Vec3(-0.18, -0.9 + sneakBonus[1], -0.3 + sneakBonus[0]), (float)mc.player.yBodyRot, (float)0.0f, (float)0.0f);
                    Vec3 vRight = VecHelper.rotate((Vec3)new Vec3(0.18, -0.9 + sneakBonus[1], -0.3 + sneakBonus[0]), (float)mc.player.yBodyRot, (float)0.0f, (float)0.0f);
                    Vec3 v = playerPos.add(vLeft).add(mc.player.getDeltaMovement().scale(jetpack.speedSide));
                    mc.particleEngine.createParticle((ParticleOptions)ParticleTypes.FLAME, v.x, v.y, v.z, (double)random, -0.2, (double)random);
                    mc.particleEngine.createParticle((ParticleOptions)ParticleTypes.SMOKE, v.x, v.y, v.z, (double)random, -0.2, (double)random);
                    v = playerPos.add(vRight).add(mc.player.getDeltaMovement().scale(jetpack.speedSide));
                    mc.particleEngine.createParticle((ParticleOptions)ParticleTypes.FLAME, v.x, v.y, v.z, (double)random, -0.2, (double)random);
                    mc.particleEngine.createParticle((ParticleOptions)ParticleTypes.SMOKE, v.x, v.y, v.z, (double)random, -0.2, (double)random);
                }
                if (((Boolean)ModConfigs.ENABLE_JETPACK_SOUNDS.get()).booleanValue() && !JetpackSound.playing(mc.player.getId())) {
                    mc.getSoundManager().play((SoundInstance)new JetpackSound((Player)mc.player));
                }
            }
        }
    }
}

