/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.ironjetpacks.util;

import com.blakebr0.ironjetpacks.client.handler.InputHandler;
import com.blakebr0.ironjetpacks.compat.curios.CuriosCompat;
import com.blakebr0.ironjetpacks.config.ModConfigs;
import com.blakebr0.ironjetpacks.init.ModDataComponentTypes;
import com.blakebr0.ironjetpacks.init.ModItems;
import com.blakebr0.ironjetpacks.item.JetpackItem;
import com.blakebr0.ironjetpacks.registry.Jetpack;
import com.blakebr0.ironjetpacks.registry.JetpackRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.energy.IEnergyStorage;

public final class JetpackUtils {
    private static final IEnergyStorage EMPTY_ENERGY_STORAGE = new EnergyStorage(0);

    public static boolean isFlying(Player player) {
        if (player.isSpectator()) {
            return false;
        }
        ItemStack stack = JetpackUtils.getEquippedJetpack(player);
        if (!stack.isEmpty() && JetpackUtils.isEngineOn(stack)) {
            Jetpack jetpack = JetpackUtils.getJetpack(stack);
            IEnergyStorage energy = JetpackUtils.getEnergyStorage(stack);
            if (energy.getEnergyStored() > 0 || player.isCreative() || jetpack.creative) {
                if (JetpackUtils.isHovering(stack)) {
                    return !player.onGround();
                }
                return InputHandler.isHoldingUp(player);
            }
        }
        return false;
    }

    public static ItemStack getEquippedJetpack(Player player) {
        ItemStack stack = player.getItemBySlot(EquipmentSlot.CHEST);
        if (!stack.isEmpty() && stack.getItem() instanceof JetpackItem) {
            return stack;
        }
        if (ModConfigs.isCuriosEnabled()) {
            return CuriosCompat.findJetpackCurio((LivingEntity)player).orElse(ItemStack.EMPTY);
        }
        return ItemStack.EMPTY;
    }

    public static IEnergyStorage getEnergyStorage(ItemStack stack) {
        IEnergyStorage energy = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        return energy == null ? EMPTY_ENERGY_STORAGE : energy;
    }

    public static boolean isEngineOn(ItemStack stack) {
        return (Boolean)stack.getOrDefault(ModDataComponentTypes.JETPACK_ENGINE, (Object)false);
    }

    public static boolean toggleEngine(ItemStack stack) {
        boolean current = (Boolean)stack.getOrDefault(ModDataComponentTypes.JETPACK_ENGINE, (Object)false);
        stack.set(ModDataComponentTypes.JETPACK_ENGINE, (Object)(!current ? 1 : 0));
        return !current;
    }

    public static boolean isHovering(ItemStack stack) {
        return (Boolean)stack.getOrDefault(ModDataComponentTypes.JETPACK_HOVER, (Object)false);
    }

    public static boolean toggleHover(ItemStack stack) {
        boolean current = (Boolean)stack.getOrDefault(ModDataComponentTypes.JETPACK_HOVER, (Object)false);
        stack.set(ModDataComponentTypes.JETPACK_HOVER, (Object)(!current ? 1 : 0));
        return !current;
    }

    public static double getThrottle(ItemStack stack) {
        return (Double)stack.getOrDefault(ModDataComponentTypes.JETPACK_THROTTLE, (Object)1.0);
    }

    public static double incrementThrottle(ItemStack stack) {
        double throttle = JetpackUtils.getThrottle(stack);
        if (throttle < 1.0) {
            throttle = Math.min(throttle + 0.2, 1.0);
            stack.set(ModDataComponentTypes.JETPACK_THROTTLE, (Object)throttle);
        }
        return throttle;
    }

    public static double decrementThrottle(ItemStack stack) {
        double throttle = JetpackUtils.getThrottle(stack);
        if (throttle > 0.2) {
            throttle = Math.max(throttle - 0.2, 0.2);
            stack.set(ModDataComponentTypes.JETPACK_THROTTLE, (Object)throttle);
        }
        return throttle;
    }

    public static boolean isHUDEnabled(ItemStack stack) {
        return (Boolean)stack.getOrDefault(ModDataComponentTypes.JETPACK_HUD, (Object)true);
    }

    public static boolean toggleHUD(ItemStack stack) {
        boolean current = (Boolean)stack.getOrDefault(ModDataComponentTypes.JETPACK_HUD, (Object)true);
        stack.set(ModDataComponentTypes.JETPACK_HUD, (Object)(!current ? 1 : 0));
        return !current;
    }

    public static ItemStack getItemForJetpack(Jetpack jetpack) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.JETPACK.get());
        stack.set(ModDataComponentTypes.JETPACK_ID, (Object)jetpack.getId());
        return stack;
    }

    public static ItemStack getItemForComponent(Item item, Jetpack jetpack) {
        ItemStack stack = new ItemStack((ItemLike)item);
        stack.set(ModDataComponentTypes.JETPACK_ID, (Object)jetpack.getId());
        return stack;
    }

    public static Jetpack getJetpack(ItemStack stack) {
        ResourceLocation id = (ResourceLocation)stack.get(ModDataComponentTypes.JETPACK_ID);
        if (id != null) {
            return JetpackRegistry.getInstance().getJetpackById(id);
        }
        return Jetpack.UNDEFINED;
    }
}

