/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbjeiextras.geneticsresequenced.recipes.incubator;

import dev.aaronhowser.mods.geneticsresequenced.item.EntityDnaItem;
import dev.aaronhowser.mods.geneticsresequenced.item.GmoCell;
import dev.aaronhowser.mods.geneticsresequenced.recipe.BrewingRecipes;
import dev.aaronhowser.mods.geneticsresequenced.recipe.incubator.GmoRecipe;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModGenes;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import dev.ftb.mods.ftbjeiextras.geneticsresequenced.recipes.incubator.IncubatorRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;

public class CellDupeRecipe
implements IncubatorRecipe {
    private final Ingredient input = Ingredient.of((ItemStack[])new ItemStack[]{BrewingRecipes.INSTANCE.getSubstratePotionStack()});
    private final ItemStack output;
    private final Ingredient ingredient;

    public CellDupeRecipe(ItemStack cellStack) {
        this.output = cellStack.copy();
        this.ingredient = Ingredient.of((ItemStack[])new ItemStack[]{cellStack});
    }

    @Override
    public Ingredient ingredient() {
        return this.ingredient;
    }

    @Override
    public Ingredient input() {
        return this.input;
    }

    @Override
    public ItemStack output() {
        return this.output;
    }

    public static List<CellDupeRecipe> collectAllRecipes(RecipeManager recipeManager, RegistryAccess registryAccess) {
        ArrayList<CellDupeRecipe> recipes = new ArrayList<CellDupeRecipe>();
        Set validEntityTypes = EntityDnaItem.Companion.getValidEntityTypes();
        for (EntityType entityType : validEntityTypes) {
            ItemStack stack = ModItems.INSTANCE.getCELL().toStack();
            EntityDnaItem.Companion.setEntityType(stack, entityType);
            recipes.add(new CellDupeRecipe(stack));
        }
        List allGmoRecipes = GmoRecipe.Companion.getGmoRecipes(recipeManager);
        for (RecipeHolder recipe : allGmoRecipes) {
            EntityType entityType = ((GmoRecipe)recipe.value()).getEntityType();
            ResourceKey goodGene = ((GmoRecipe)recipe.value()).getIdealGeneRk();
            ItemStack gmoCellStack = ModItems.INSTANCE.getGMO_CELL().toStack();
            GmoCell.Companion.setDetails(gmoCellStack, entityType, (Holder)ModGenes.INSTANCE.getHolderOrThrow(goodGene, (HolderLookup.Provider)registryAccess));
            recipes.add(new CellDupeRecipe(gmoCellStack));
        }
        return recipes;
    }
}

