/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbjeiextras.geneticsresequenced.recipes.incubator;

import dev.aaronhowser.mods.geneticsresequenced.item.EntityDnaItem;
import dev.aaronhowser.mods.geneticsresequenced.recipe.BrewingRecipes;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import dev.ftb.mods.ftbjeiextras.geneticsresequenced.recipes.incubator.IncubatorRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;

public class SetPotionEntityRecipe
implements IncubatorRecipe {
    private final Ingredient ingredient;
    private final Ingredient input;
    private final ItemStack output;

    public SetPotionEntityRecipe(EntityType<?> entityType, boolean mutation) {
        ItemStack cell = ModItems.INSTANCE.getCELL().toStack();
        EntityDnaItem.Companion.setEntityType(cell, entityType);
        this.ingredient = Ingredient.of((ItemStack[])new ItemStack[]{cell});
        ItemStack potion = mutation ? BrewingRecipes.INSTANCE.getMutationPotionStack() : BrewingRecipes.INSTANCE.getCellGrowthPotionStack();
        this.input = Ingredient.of((ItemStack[])new ItemStack[]{potion});
        EntityDnaItem.Companion.setEntityType(potion, entityType);
        this.output = potion;
    }

    @Override
    public Ingredient ingredient() {
        return this.ingredient;
    }

    @Override
    public Ingredient input() {
        return this.input;
    }

    @Override
    public ItemStack output() {
        return this.output;
    }

    public static List<SetPotionEntityRecipe> collectAllRecipes(RecipeManager recipeManager) {
        ArrayList<SetPotionEntityRecipe> recipes = new ArrayList<SetPotionEntityRecipe>();
        Set validEntityTypes = EntityDnaItem.Companion.getValidEntityTypes();
        for (EntityType validEntityType : validEntityTypes) {
            recipes.add(new SetPotionEntityRecipe(validEntityType, false));
            recipes.add(new SetPotionEntityRecipe(validEntityType, true));
        }
        return recipes;
    }
}

