/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.swedz.little_big_redstone.LBR;
import net.swedz.little_big_redstone.LBRColors;
import net.swedz.little_big_redstone.LBRItems;
import net.swedz.little_big_redstone.LBRSortOrder;
import net.swedz.little_big_redstone.LBRTags;
import net.swedz.little_big_redstone.block.microchip.MicrochipBlock;
import net.swedz.little_big_redstone.block.microchip.MicrochipBlockEntity;
import net.swedz.tesseract.neoforge.api.Assert;
import net.swedz.tesseract.neoforge.helper.model.BasicCustomLoaderBuilder;
import net.swedz.tesseract.neoforge.registry.SortOrder;
import net.swedz.tesseract.neoforge.registry.common.CommonLootTableBuilders;
import net.swedz.tesseract.neoforge.registry.holder.BlockHolder;
import net.swedz.tesseract.neoforge.registry.holder.BlockWithItemHolder;
import org.apache.commons.lang3.function.TriConsumer;

public final class LBRBlocks {
    private static final Map<DyeColor, BlockHolder<MicrochipBlock>> MICROCHIPS;
    public static final Supplier<BlockEntityType<MicrochipBlockEntity>> MICROCHIP_ENTITY;

    public static void init(IEventBus bus) {
        Registry.init(bus);
    }

    public static BlockHolder<MicrochipBlock> microchip(DyeColor color) {
        Assert.notNull((Object)color);
        return MICROCHIPS.get(color);
    }

    public static Set<BlockHolder> values() {
        return Set.copyOf(Registry.HOLDERS);
    }

    private static <BlockType extends Block> BlockHolder<BlockType> create(String id, String englishName, Function<BlockBehaviour.Properties, BlockType> blockCreator) {
        BlockHolder holder = new BlockHolder(LBR.id(id), englishName, Registry.BLOCKS, blockCreator);
        Registry.include(holder);
        return holder;
    }

    private static <BlockType extends Block, ItemType extends BlockItem> BlockWithItemHolder<BlockType, ItemType> create(String id, String englishName, Function<BlockBehaviour.Properties, BlockType> blockCreator, BiFunction<Block, Item.Properties, ItemType> itemCreator, SortOrder sortOrder) {
        BlockWithItemHolder holder = new BlockWithItemHolder(LBR.id(id), englishName, Registry.BLOCKS, blockCreator, LBRItems.Registry.ITEMS, itemCreator);
        holder.item().sorted(sortOrder);
        Registry.include((BlockHolder)holder);
        LBRItems.Registry.include(holder.item());
        return holder;
    }

    private static BlockHolder<MicrochipBlock> createMicrochip(DyeColor color, String colorEnglishName, int order) {
        String colorId = color.getName();
        String id = "%s_microchip".formatted(colorId);
        String englishName = "%s Microchip".formatted(colorEnglishName);
        BlockWithItemHolder<MicrochipBlock, BlockItem> holder = LBRBlocks.create(id, englishName, p -> new MicrochipBlock((BlockBehaviour.Properties)p, color), BlockItem::new, LBRSortOrder.MICROCHIP.and((Comparable)Integer.valueOf(order)));
        ((BlockHolder)holder.withProperties(p -> p.mapColor(MapColor.STONE).destroyTime(4.0f).requiresCorrectToolForDrops()).tag(new TagKey[]{LBRTags.Blocks.MICROCHIPS, BlockTags.MINEABLE_WITH_PICKAXE})).withLootTable(CommonLootTableBuilders::self).withModel(block -> provider -> provider.simpleBlockWithItem(block.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BasicCustomLoaderBuilder)((BlockModelBuilder)((BlockModelBuilder)provider.models().getBuilder(block.identifier().id())).parent((ModelFile)new ModelFile.UncheckedModelFile("block/block"))).customLoader((parent, efh) -> new BasicCustomLoaderBuilder(LBR.id("microchip"), (ModelBuilder)parent, efh))).end()).texture("particle", LBR.id("block/microchip/side/%s".formatted(colorId)))).texture("base_up", LBR.id("block/microchip/top/%s".formatted(colorId)))).texture("base", LBR.id("block/microchip/side/%s".formatted(colorId)))).texture("base_down", LBR.id("block/microchip/bottom/%s".formatted(colorId)))).texture("signal_on_overlay", LBR.id("block/microchip/signal_on_overlay"))).texture("signal_off_overlay", LBR.id("block/microchip/signal_off_overlay"))));
        holder.item().tag(new TagKey[]{LBRTags.Items.MICROCHIPS});
        return holder;
    }

    static {
        HashMap microchips = Maps.newHashMap();
        LBRColors.forEachIndexed((TriConsumer<DyeColor, String, Integer>)((TriConsumer)(color, colorName, index) -> microchips.put(color, LBRBlocks.createMicrochip(color, colorName, index).register())));
        MICROCHIPS = Collections.unmodifiableMap(microchips);
        MICROCHIP_ENTITY = Registry.BLOCK_ENTITIES.register("microchip", () -> BlockEntityType.Builder.of(MicrochipBlockEntity::new, (Block[])((Block[])MICROCHIPS.values().stream().map(BlockHolder::get).toArray(Block[]::new))).build(null));
    }

    public static final class Registry {
        public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"little_big_redstone");
        public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (String)"little_big_redstone");
        private static final Set<BlockHolder> HOLDERS = Sets.newHashSet();

        private static void init(IEventBus bus) {
            BLOCKS.register(bus);
            BLOCK_ENTITIES.register(bus);
        }

        public static void include(BlockHolder holder) {
            HOLDERS.add(holder);
        }
    }
}

