/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone;

import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.swedz.little_big_redstone.LBR;
import net.swedz.little_big_redstone.LBRComponents;
import net.swedz.little_big_redstone.LBRTags;
import net.swedz.little_big_redstone.microchip.object.logic.LogicComponent;
import net.swedz.tesseract.neoforge.tooltip.BiParser;
import net.swedz.tesseract.neoforge.tooltip.Parser;
import net.swedz.tesseract.neoforge.tooltip.TooltipAttachment;

public final class LBRTooltips {
    public static final Parser<Boolean> INPUT_OUTPUT_PARSER = input -> input != false ? LBR.text().input() : LBR.text().output();
    public static final Parser<Direction> DIRECTION_PARSER = direction -> switch (direction) {
        default -> throw new MatchException(null, null);
        case Direction.DOWN -> LBR.text().directionDown();
        case Direction.UP -> LBR.text().directionUp();
        case Direction.NORTH -> LBR.text().directionNorth();
        case Direction.SOUTH -> LBR.text().directionSouth();
        case Direction.WEST -> LBR.text().directionWest();
        case Direction.EAST -> LBR.text().directionEast();
    };
    public static final Parser<Boolean> BOOLEAN_YES_NO_PARSER = value -> value != false ? LBR.text().yes() : LBR.text().no();
    public static final BiParser<Double, String> TICKS_AND_SECONDS_SLIDER_PARSER = (value, string) -> {
        boolean singular = value.intValue() == 1;
        long ticks = Long.parseLong(string);
        float seconds = value.floatValue() / 20.0f;
        return singular ? LBR.text().logicConfigButtonLabelTicksAndSecondsSingular(ticks, seconds) : LBR.text().logicConfigButtonLabelTicksAndSeconds(ticks, seconds);
    };
    public static final TooltipAttachment LOGIC_GATE_NO_SHIFT = TooltipAttachment.multilinesOptional((stack, item) -> stack.has(LBRComponents.LOGIC), (flag, context, stack, item) -> {
        LogicComponent logicComponent = (LogicComponent)stack.get(LBRComponents.LOGIC);
        return logicComponent.type().tooltip(logicComponent, false, false);
    }).noShiftRequired();
    public static final TooltipAttachment LOGIC_GATE_SHIFT = TooltipAttachment.multilinesOptional((stack, item) -> stack.has(LBRComponents.LOGIC), (flag, context, stack, item) -> {
        LogicComponent logicComponent = (LogicComponent)stack.get(LBRComponents.LOGIC);
        return logicComponent.type().tooltip(logicComponent, true, true);
    });
    public static final TooltipAttachment LOGIC_ARRAY = TooltipAttachment.multilines((stack, item) -> stack.is(LBRTags.Items.LOGIC_ARRAYS), List.of(LBR.text().logicArrayHelp1(), LBR.text().logicArrayHelp2(), Component.empty(), LBR.text().logicArrayHelp3("use"), LBR.text().logicArrayHelp4("use")));
    public static final TooltipAttachment FLOPPY_DISK = TooltipAttachment.multilines((stack, item) -> stack.is(LBRTags.Items.FLOPPY_DISKS), List.of(LBR.text().floppyDiskHelp1(), Component.empty(), LBR.text().floppyDiskHelp2("sneak", "use"), LBR.text().floppyDiskHelp3("use"), LBR.text().floppyDiskHelp4("use")));

    public static void init() {
    }
}

