/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.block.microchip;

import com.mojang.serialization.DynamicOps;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.swedz.little_big_redstone.LBR;
import net.swedz.little_big_redstone.LBRBlocks;
import net.swedz.little_big_redstone.block.microchip.MicrochipBlock;
import net.swedz.little_big_redstone.client.model.microchip.MicrochipModelData;
import net.swedz.little_big_redstone.gui.microchip.MicrochipMenu;
import net.swedz.little_big_redstone.gui.microchip.MicrochipViewPosition;
import net.swedz.little_big_redstone.microchip.Microchip;
import net.swedz.little_big_redstone.microchip.MicrochipSize;
import net.swedz.little_big_redstone.microchip.awareness.AwarenessContext;
import net.swedz.little_big_redstone.microchip.awareness.AwarenessTypes;
import net.swedz.little_big_redstone.microchip.awareness.types.RedstoneAwareness;
import net.swedz.little_big_redstone.microchip.object.logic.LogicContext;
import net.swedz.little_big_redstone.network.packet.UpdateComponentsMicrochipMenuPacket;
import net.swedz.little_big_redstone.network.packet.UpdateMicrochipMenuPacket;
import net.swedz.little_big_redstone.network.packet.UpdateMicrochipWatcherPacket;
import net.swedz.tesseract.neoforge.api.Bounds;
import net.swedz.tesseract.neoforge.api.Tickable;
import net.swedz.tesseract.neoforge.packet.CustomPacket;

public final class MicrochipBlockEntity
extends BlockEntity
implements MenuProvider,
Tickable {
    public static final Bounds CIRCUIT_BOUNDS = new Bounds(0, 0, 240, 128);
    private final Microchip microchip = new Microchip(MicrochipSize.create(CIRCUIT_BOUNDS, 0.5f));
    private boolean modelDataChanged = true;
    private MicrochipModelData modelData;

    public MicrochipBlockEntity(BlockPos pos, BlockState blockState) {
        super(LBRBlocks.MICROCHIP_ENTITY.get(), pos, blockState);
    }

    public Microchip microchip() {
        return this.microchip;
    }

    public DyeColor color() {
        return ((MicrochipBlock)this.getBlockState().getBlock()).color();
    }

    public Component getDisplayName() {
        return Component.translatable((String)this.getBlockState().getBlock().getDescriptionId());
    }

    public void sync() {
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            throw new IllegalStateException("Cannot call sync() on the logical client");
        }
        ServerLevel serverLevel = (ServerLevel)level;
        this.modelDataChanged = true;
        serverLevel.getChunkSource().blockChanged(this.worldPosition);
    }

    private MicrochipModelData createModelData() {
        MicrochipModelData data = new MicrochipModelData();
        RedstoneAwareness redstone = this.microchip.awarenesses().get(AwarenessTypes.REDSTONE);
        if (redstone != null) {
            data.sides(redstone.getSides());
        }
        return data;
    }

    public ModelData getModelData() {
        return ModelData.builder().with(MicrochipModelData.KEY, (Object)this.modelData).build();
    }

    private boolean isMenuValid(Player player) {
        return !this.isRemoved() && player.level() == this.level && this.worldPosition.getCenter().distanceTo(player.position()) <= 16.0;
    }

    public AbstractContainerMenu createMenu(int containerId, Inventory inventory, Player player) {
        return new MicrochipMenu(containerId, inventory, this.worldPosition, this::isMenuValid, this.microchip, this.color(), new MicrochipViewPosition());
    }

    public boolean openMenu(Player player, MicrochipViewPosition viewPosition) {
        if (this.isMenuValid(player)) {
            player.openMenu((MenuProvider)this, buf -> {
                buf.writeBlockPos(this.worldPosition);
                Microchip.STREAM_CODEC.encode(buf, (Object)this.microchip);
                DyeColor.STREAM_CODEC.encode(buf, (Object)this.color());
                MicrochipViewPosition.STREAM_CODEC.encode(buf, (Object)viewPosition);
            });
            return true;
        }
        return false;
    }

    public boolean openMenu(Player player) {
        return this.openMenu(player, new MicrochipViewPosition());
    }

    public void tick() {
        if (this.level.isClientSide()) {
            return;
        }
        this.microchip.awarenesses().preTick(new AwarenessContext(this));
        LogicContext context = new LogicContext(this);
        this.microchip.tickLogic(context);
        boolean microchipDirty = this.microchip.isDirty();
        boolean contextDirty = context.isDirty();
        if (microchipDirty || contextDirty) {
            this.microchip.markClean();
            this.microchip.awarenesses().postTick(new AwarenessContext(this), microchipDirty, contextDirty);
            this.setChanged();
            if (microchipDirty) {
                MicrochipModelData newModelData = this.createModelData();
                if (!newModelData.equals(this.modelData)) {
                    this.modelData = newModelData;
                    this.sync();
                }
                this.publishUpdatePacket(container -> new UpdateMicrochipMenuPacket((int)container, this.microchip), () -> new UpdateMicrochipWatcherPacket(this.microchip));
            } else if (contextDirty) {
                this.publishUpdatePacket(container -> new UpdateComponentsMicrochipMenuPacket((int)container, context.getDirtyEntries()));
            }
        }
    }

    private void publishUpdatePacket(Function<Integer, CustomPacket> containerPacketCreator, Supplier<CustomPacket> watcherPacketCreator) {
        for (Player player : this.level.players()) {
            MicrochipMenu menu;
            AbstractContainerMenu abstractContainerMenu = player.containerMenu;
            if (abstractContainerMenu instanceof MicrochipMenu && this.worldPosition.equals((Object)(menu = (MicrochipMenu)abstractContainerMenu).blockPos())) {
                containerPacketCreator.apply(menu.containerId).sendToClient((ServerPlayer)player);
            }
            if (!this.worldPosition.equals((Object)player.getWatchedMicrochip()) || watcherPacketCreator == null) continue;
            watcherPacketCreator.get().sendToClient((ServerPlayer)player);
        }
    }

    private void publishUpdatePacket(Function<Integer, CustomPacket> containerPacketCreator) {
        this.publishUpdatePacket(containerPacketCreator, null);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        if (this.modelDataChanged) {
            this.modelDataChanged = false;
            tag.put("microchip_model_data", (Tag)MicrochipModelData.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.createModelData()).getOrThrow());
        }
        return tag;
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("microchip", 10)) {
            Microchip.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.getCompound("microchip")).ifSuccess(this.microchip::loadFrom).ifError(error -> LBR.LOGGER.error("Failed to load microchip data at {}: {}", (Object)this.worldPosition.toShortString(), (Object)error.message()));
        } else {
            this.microchip.clear();
        }
        if (this.level != null && this.level.isClientSide() && tag.contains("microchip_model_data", 10)) {
            MicrochipModelData.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.getCompound("microchip_model_data")).ifSuccess(modelData -> {
                this.modelData = modelData;
            }).ifError(error -> {
                this.modelData = null;
                LBR.LOGGER.error("Failed to load microchip model data at {}: {}", (Object)this.worldPosition.toShortString(), (Object)error.message());
            });
            this.level.sendBlockUpdated(this.worldPosition, null, null, 0);
            this.requestModelDataUpdate();
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("microchip", (Tag)Microchip.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.microchip).getOrThrow());
    }
}

