/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.client.model.stickynote.entity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.IDynamicBakedModel;
import net.neoforged.neoforge.client.model.QuadTransformers;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.swedz.little_big_redstone.LBRColors;
import net.swedz.little_big_redstone.client.model.stickynote.StickyNoteModelData;

public final class StickyNoteEntityBakedModel
implements IDynamicBakedModel {
    private final ItemTransforms transforms;
    private final boolean useAmbientOcclusion;
    private final boolean isGui3d;
    private final boolean usesBlockLight;
    private final TextureAtlasSprite particle;
    private final ImmutableList<BakedModel> baseLayer;
    private final ImmutableList<BakedModel> textLayer;

    StickyNoteEntityBakedModel(ItemTransforms transforms, boolean useAmbientOcclusion, boolean isGui3d, boolean usesBlockLight, TextureAtlasSprite particle, ImmutableList<BakedModel> baseLayer, ImmutableList<BakedModel> textLayer) {
        this.transforms = transforms;
        this.useAmbientOcclusion = useAmbientOcclusion;
        this.isGui3d = isGui3d;
        this.usesBlockLight = usesBlockLight;
        this.particle = particle;
        this.baseLayer = baseLayer;
        this.textLayer = textLayer;
    }

    public List<BakedQuad> getQuads(BlockState state, Direction side, RandomSource random, ModelData modelData, RenderType renderType) {
        StickyNoteModelData data = StickyNoteModelData.get(modelData);
        ArrayList quads = Lists.newArrayList();
        for (BakedModel model : this.baseLayer) {
            quads.addAll(model.getQuads(state, side, random, modelData, renderType));
        }
        if (data.hasText()) {
            for (BakedModel model : this.textLayer) {
                for (BakedQuad quad : model.getQuads(state, side, random, modelData, renderType)) {
                    BakedQuad copy = new BakedQuad(quad.getVertices(), 0, quad.getDirection(), quad.getSprite(), quad.isShade(), quad.hasAmbientOcclusion());
                    QuadTransformers.applyingColor((int)LBRColors.stickyNoteText(data.textColor())).processInPlace(copy);
                    quads.add(copy);
                }
            }
        }
        return quads;
    }

    public boolean useAmbientOcclusion() {
        return this.useAmbientOcclusion;
    }

    public boolean isGui3d() {
        return this.isGui3d;
    }

    public boolean usesBlockLight() {
        return this.usesBlockLight;
    }

    public boolean isCustomRenderer() {
        return false;
    }

    public TextureAtlasSprite getParticleIcon() {
        return this.particle;
    }

    public ItemOverrides getOverrides() {
        return ItemOverrides.EMPTY;
    }

    public ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
        return ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.CUTOUT});
    }

    public BakedModel applyTransform(ItemDisplayContext transformType, PoseStack poseStack, boolean applyLeftHandTransform) {
        super.applyTransform(transformType, poseStack, applyLeftHandTransform);
        this.transforms.getTransform(transformType).apply(applyLeftHandTransform, poseStack);
        return this;
    }
}

