/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.compat.emi.recipe;

import dev.emi.emi.EmiUtil;
import dev.emi.emi.api.recipe.EmiPatternCraftingRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.GeneratedSlotWidget;
import dev.emi.emi.api.widget.SlotWidget;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.swedz.little_big_redstone.recipe.DataRetainingDyeRecipe;
import org.apache.commons.lang3.mutable.MutableInt;

public final class DataRetainingDyeEmiRecipe
extends EmiPatternCraftingRecipe {
    private static final List<DyeItem> DYES = Stream.of(DyeColor.values()).map(DyeItem::byColor).toList();
    private final List<Item> inputItems;

    public DataRetainingDyeEmiRecipe(TagKey<Item> inputItemTag, ResourceLocation id) {
        super(List.of(EmiIngredient.of(DYES.stream().map(EmiStack::of).toList()), EmiIngredient.of(inputItemTag)), EmiStack.EMPTY, id);
        this.inputItems = EmiUtil.values(inputItemTag).map(Holder::value).toList();
    }

    private Item getItem(MutableInt index) {
        Item item = this.inputItems.get(index.getAndIncrement());
        if (index.getValue() >= this.inputItems.size()) {
            index.setValue(0);
        }
        return item;
    }

    private DyeItem getDye(MutableInt index) {
        DyeItem inputDye = DYES.get(index.getAndIncrement());
        if (index.getValue() >= DYES.size()) {
            index.setValue(0);
        }
        return inputDye;
    }

    public SlotWidget getInputWidget(int slot, int x, int y) {
        if (slot == 0) {
            MutableInt index = new MutableInt();
            return new GeneratedSlotWidget(random -> EmiStack.of((ItemLike)this.getItem(index)), this.unique, x, y);
        }
        if (slot == 1) {
            MutableInt index = new MutableInt();
            return new GeneratedSlotWidget(random -> EmiStack.of((ItemLike)this.getDye(index)), this.unique, x, y);
        }
        return new SlotWidget((EmiIngredient)EmiStack.EMPTY, x, y);
    }

    public SlotWidget getOutputWidget(int x, int y) {
        MutableInt itemIndex = new MutableInt();
        MutableInt dyeIndex = new MutableInt();
        return new GeneratedSlotWidget(random -> {
            Item inputItem = this.getItem(itemIndex);
            DyeItem dyeItem = this.getDye(dyeIndex);
            return EmiStack.of((ItemStack)DataRetainingDyeRecipe.outputVariant(new ItemStack((ItemLike)inputItem), Optional.of(dyeItem.getDyeColor())));
        }, this.unique, x, y);
    }
}

