/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.gui.logicconfig.button.cycle;

import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.swedz.little_big_redstone.gui.logicconfig.button.LogicConfigButtonHelper;
import net.swedz.tesseract.neoforge.helper.guigraphics.TesseractGuiGraphics;

public class CycleLogicConfigButton<T>
extends AbstractButton
implements LogicConfigButtonHelper {
    private final int color;
    private final List<T> allowedValues;
    private final boolean displayOnlyValue;
    private final ValueStringifier<T> stringifier;
    private final OnValueChange<T> onValueChange;
    private int valueIndex;
    private T value;

    public CycleLogicConfigButton(int x, int y, int width, int height, int color, Component message, boolean displayOnlyValue, T initialValue, List<T> allowedValues, ValueStringifier<T> stringifier, OnValueChange<T> onValueChange) {
        super(x, y, width, height, message);
        this.color = color;
        this.displayOnlyValue = displayOnlyValue;
        this.allowedValues = allowedValues;
        this.stringifier = stringifier;
        this.onValueChange = onValueChange;
        this.setValue(initialValue);
    }

    public T value() {
        return this.value;
    }

    public void setValue(T value) {
        int index = this.allowedValues.indexOf(value);
        if (index == -1) {
            throw new IllegalArgumentException("Button does not support value " + String.valueOf(value));
        }
        this.valueIndex = index;
        this.value = value;
        this.onValueChange.onValueChange(this, value);
    }

    private void next() {
        this.valueIndex = (this.valueIndex + 1) % this.allowedValues.size();
        this.value = this.allowedValues.get(this.valueIndex);
        this.onValueChange.onValueChange(this, this.value);
    }

    public void onPress() {
        this.next();
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    protected void renderWidget(GuiGraphics internal, int mouseX, int mouseY, float partialTick) {
        TesseractGuiGraphics graphics = new TesseractGuiGraphics(internal);
        this.renderBackground(graphics, partialTick, this.getX(), this.getY(), this.width, this.height, this.color, this.active && this.isHoveredOrFocused());
        this.renderBorder(graphics, this.getX(), this.getY(), this.width, this.height, this.color);
        graphics.setColor(this.color);
        graphics.setStringDropShadow(false);
        Component valueText = this.stringifier.stringify(this.value);
        Component text = this.displayOnlyValue ? valueText : CommonComponents.optionNameValue((Component)this.getMessage(), (Component)valueText);
        graphics.drawCenteredString(text, (float)this.getX() + (float)this.width / 2.0f, (float)this.getY() + (float)this.height / 2.0f);
        graphics.resetColor();
    }

    public static interface ValueStringifier<T> {
        public Component stringify(T var1);
    }

    public static interface OnValueChange<T> {
        public void onValueChange(CycleLogicConfigButton<T> var1, T var2);
    }
}

