/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.gui.microchip;

import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.swedz.little_big_redstone.LBR;
import net.swedz.little_big_redstone.LBRClientShaders;
import net.swedz.little_big_redstone.LBRComponents;
import net.swedz.little_big_redstone.LBRItemDisplayContext;
import net.swedz.little_big_redstone.LBRItems;
import net.swedz.little_big_redstone.block.microchip.MicrochipBlockEntity;
import net.swedz.little_big_redstone.gui.logicarray.slot.LogicArrayPlayerSlot;
import net.swedz.little_big_redstone.gui.microchip.MicrochipMenu;
import net.swedz.little_big_redstone.gui.microchip.logic.LogicRenderer;
import net.swedz.little_big_redstone.gui.microchip.logic.LogicRenderers;
import net.swedz.little_big_redstone.gui.microchip.widget.MicrochipWidget;
import net.swedz.little_big_redstone.gui.microchip.wire.WireEndpoints;
import net.swedz.little_big_redstone.item.stickynote.StickyNoteItem;
import net.swedz.little_big_redstone.microchip.Microchip;
import net.swedz.little_big_redstone.microchip.MicrochipSize;
import net.swedz.little_big_redstone.microchip.object.logic.LogicComponent;
import net.swedz.little_big_redstone.microchip.wire.Wire;
import net.swedz.tesseract.neoforge.api.Bounds;
import net.swedz.tesseract.neoforge.helper.guigraphics.TesseractGuiGraphics;

public final class MicrochipScreen
extends AbstractContainerScreen<MicrochipMenu> {
    private static final ResourceLocation MICROCHIP_BACKGROUND = LBR.id("textures/gui/container/microchip/inventory_background.png");
    private static final ResourceLocation LOGIC_ARRAY_BACKGROUND = LBR.id("textures/gui/container/logic_array/microchip_inventory_background.png");
    private MicrochipWidget microchipWidget;
    private float partialTicks;

    public static int getGridSnappedCoord(int coord) {
        return coord / 16 * 16;
    }

    public MicrochipScreen(MicrochipMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageWidth = 256;
        this.imageHeight = 227;
    }

    public void handleUpdate() {
        this.microchipWidget.handleUpdate();
    }

    private boolean isWithinBoard(int x, int y) {
        return ((MicrochipMenu)this.menu).microchip().size().bounds().contains(x, y);
    }

    protected void init() {
        super.init();
        this.microchipWidget = new MicrochipWidget(this.leftPos + 8, this.topPos + 8, this, ((MicrochipMenu)this.menu).viewPosition());
        this.addRenderableWidget(this.microchipWidget);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        boolean drag = this.getFocused() != null && this.isDragging() && button == 0 && this.getFocused().mouseDragged(mouseX, mouseY, button, dragX, dragY);
        return drag || super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected void renderSlot(GuiGraphics vanilla, Slot slot) {
        TesseractGuiGraphics graphics = new TesseractGuiGraphics(vanilla);
        if (slot instanceof LogicArrayPlayerSlot && slot.index == ((MicrochipMenu)this.menu).getLogicArrayItemHandler().getSelectedSlot()) {
            graphics.pose().pushPose();
            graphics.pose().translate(0.0f, 0.0f, 100.0f);
            graphics.setTexture(LBR.id("textures/gui/slot_atlas.png"));
            graphics.blit(slot.x - 1, slot.y - 1, 0, 18, 18, 18);
            this.renderSlotContents(vanilla, slot.getItem(), slot, null);
            graphics.pose().popPose();
            return;
        }
        super.renderSlot(vanilla, slot);
    }

    public void renderFloatingItem(GuiGraphics vanilla, ItemStack stack, int localX, int localY, String text) {
        int mouseX = localX + this.leftPos + 8;
        int mouseY = localY + this.topPos + 8;
        if (this.microchipWidget.isMouseOver(mouseX, mouseY)) {
            Microchip microchip = ((MicrochipMenu)this.menu).microchip();
            MicrochipSize size = microchip.size();
            int boardMouseX = size.boardCoord(localX, this.microchipWidget.viewPosition().zoom(), this.microchipWidget.viewPosition().x());
            int boardMouseY = size.boardCoord(localY, this.microchipWidget.viewPosition().zoom(), this.microchipWidget.viewPosition().y());
            TesseractGuiGraphics graphics = new TesseractGuiGraphics(vanilla);
            vanilla.enableScissor(this.microchipWidget.x(), this.microchipWidget.y(), this.microchipWidget.x() + MicrochipBlockEntity.CIRCUIT_BOUNDS.width(), this.microchipWidget.y() + MicrochipBlockEntity.CIRCUIT_BOUNDS.height());
            graphics.pose().pushPose();
            graphics.pose().translate(8.0f, 8.0f, 232.0f);
            graphics.pose().scale(size.scale(), size.scale(), 1.0f);
            graphics.pose().scale(this.microchipWidget.viewPosition().zoom(), this.microchipWidget.viewPosition().zoom(), 1.0f);
            graphics.pose().translate(-this.microchipWidget.viewPosition().x(), -this.microchipWidget.viewPosition().y(), 0.0);
            if (stack.getItem() instanceof StickyNoteItem) {
                int itemX = Screen.hasControlDown() ? MicrochipScreen.getGridSnappedCoord(boardMouseX) : boardMouseX - 8;
                int itemY = Screen.hasControlDown() ? MicrochipScreen.getGridSnappedCoord(boardMouseY) : boardMouseY - 8;
                graphics.renderItem(stack, LBRItemDisplayContext.MICROCHIP_GUI, itemX, itemY);
                graphics.pose().popPose();
                vanilla.disableScissor();
                return;
            }
            if (stack.has(LBRComponents.LOGIC)) {
                LogicComponent component = (LogicComponent)stack.get(LBRComponents.LOGIC);
                LogicRenderer.Context context = LogicRenderer.Context.create(((MicrochipMenu)this.menu).color(), component, ((MicrochipMenu)this.menu).getCarriedWires() != null, this.microchipWidget.hasSelectedPort(), false);
                int logicX = Screen.hasControlDown() ? MicrochipScreen.getGridSnappedCoord(component.size().topLeftCornerX(boardMouseX) + 8) : component.size().topLeftCornerX(boardMouseX);
                int logicY = Screen.hasControlDown() ? MicrochipScreen.getGridSnappedCoord(component.size().topLeftCornerY(boardMouseY) + 8) : component.size().topLeftCornerY(boardMouseY);
                this.renderCarriedWires(graphics, logicX, logicY, context, component);
                this.renderCarriedLogic(graphics, logicX, logicY, context, component);
                graphics.pose().popPose();
                vanilla.disableScissor();
                return;
            }
            if (stack.is(LBRItems.REDSTONE_BIT.asItem())) {
                graphics.setTexture(LBR.id("textures/item/redstone_bit.png"));
                if (!this.microchipWidget.context().hasPort()) {
                    graphics.setTextureShader(LBRClientShaders::pulsingTextureAlpha);
                }
                graphics.blit(boardMouseX - 8, boardMouseY - 8, 0.0f, 0.0f, 16, 16, 16, 16);
                graphics.renderItemDecorations(stack, boardMouseX - 8, boardMouseY - 8);
                graphics.pose().popPose();
                vanilla.disableScissor();
                return;
            }
            graphics.pose().popPose();
            vanilla.disableScissor();
        }
        super.renderFloatingItem(vanilla, stack, localX, localY, text);
    }

    private void renderCarriedWires(TesseractGuiGraphics graphics, int logicX, int logicY, LogicRenderer.Context context, LogicComponent<?, ?> component) {
        if (((MicrochipMenu)this.menu).getCarriedWires() != null) {
            Microchip microchip = ((MicrochipMenu)this.menu).microchip();
            MicrochipSize size = microchip.size();
            graphics.pose().pushPose();
            graphics.enableBatching();
            for (Wire wire : ((MicrochipMenu)this.menu).getCarriedWires()) {
                WireEndpoints endpoints = WireEndpoints.carried(this.microchipWidget.context(), ((MicrochipMenu)this.menu).getCarriedComponentSlot(), component, wire, logicX, logicY);
                List<Bounds> avoidBounds = List.of(this.microchipWidget.panel().wires().pathing().mutateComponentBounds(component.size().toBounds(logicX, logicY)));
                this.microchipWidget.panel().wires().renderWire(graphics, avoidBounds, endpoints, true);
            }
            graphics.drawBatches();
            graphics.pose().popPose();
        }
    }

    private void renderCarriedLogic(TesseractGuiGraphics graphics, int logicX, int logicY, LogicRenderer.Context context, LogicComponent<?, ?> component) {
        Microchip microchip = ((MicrochipMenu)this.menu).microchip();
        MicrochipSize size = microchip.size();
        graphics.pose().pushPose();
        graphics.enableBatching();
        LogicRenderers.render(context, graphics, component, logicX, logicY);
        graphics.drawBatches();
        graphics.pose().popPose();
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        this.partialTicks = partialTicks;
        graphics.pose().pushPose();
        graphics.pose().translate((float)this.leftPos, (float)this.topPos, 0.0f);
        graphics.blit(MICROCHIP_BACKGROUND, 0, 0, 0, 0, 256, 256);
        if (((MicrochipMenu)this.menu).getLogicArrayItemHandler().shouldDisplay()) {
            graphics.blit(LOGIC_ARRAY_BACKGROUND, -83, 0, 0, 0, 256, 256);
        }
        graphics.pose().popPose();
    }
}

