/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.gui.microchip;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.swedz.little_big_redstone.block.microchip.MicrochipBlockEntity;
import net.swedz.little_big_redstone.microchip.MicrochipSize;

public final class MicrochipViewPosition {
    public static final StreamCodec<ByteBuf, MicrochipViewPosition> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.DOUBLE, MicrochipViewPosition::x, (StreamCodec)ByteBufCodecs.DOUBLE, MicrochipViewPosition::y, (StreamCodec)ByteBufCodecs.FLOAT, MicrochipViewPosition::zoom, MicrochipViewPosition::new);
    private MicrochipSize size;
    private int originX;
    private int originY;
    private double x;
    private double y;
    private float zoom = 1.0f;

    public MicrochipViewPosition(double x, double y, float zoom) {
        this.x = x;
        this.y = y;
        this.zoom = zoom;
    }

    public MicrochipViewPosition() {
    }

    public void init(MicrochipSize size, int x, int y) {
        this.size = size;
        this.originX = x;
        this.originY = y;
        this.x = this.clampOffset(this.x, MicrochipBlockEntity.CIRCUIT_BOUNDS.width());
        this.y = this.clampOffset(this.y, MicrochipBlockEntity.CIRCUIT_BOUNDS.height());
        this.zoom = this.clampZoom(this.zoom);
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public void pan(double dragX, double dragY) {
        double ox = this.x - dragX / (double)this.size.scale() / (double)this.zoom;
        double oy = this.y - dragY / (double)this.size.scale() / (double)this.zoom;
        this.x = this.clampOffset(ox, MicrochipBlockEntity.CIRCUIT_BOUNDS.width());
        this.y = this.clampOffset(oy, MicrochipBlockEntity.CIRCUIT_BOUNDS.height());
    }

    public float zoom() {
        return this.zoom;
    }

    public void zoom(float amount, double mouseX, double mouseY) {
        float newZoom = this.clampZoom(this.zoom + amount);
        if (newZoom == this.zoom) {
            return;
        }
        double localMouseX = mouseX - (double)this.originX;
        double localMouseY = mouseY - (double)this.originY;
        double boardMouseX = this.size.boardCoord(localMouseX, this.zoom, this.x);
        double boardMouseY = this.size.boardCoord(localMouseY, this.zoom, this.y);
        this.zoom = (float)Math.round(newZoom * 100.0f) / 100.0f;
        double ox = this.size.boardCoord(-localMouseX, this.zoom, boardMouseX);
        double oy = this.size.boardCoord(-localMouseY, this.zoom, boardMouseY);
        this.x = this.clampOffset(ox, MicrochipBlockEntity.CIRCUIT_BOUNDS.width());
        this.y = this.clampOffset(oy, MicrochipBlockEntity.CIRCUIT_BOUNDS.height());
    }

    private float clampZoom(float zoom) {
        if (zoom < 1.0f) {
            return 1.0f;
        }
        if ((double)zoom > 2.5) {
            return 2.5f;
        }
        return zoom;
    }

    private double clampOffset(double offset, double bounds) {
        double max;
        double circuitBounds = bounds / (double)this.size.scale();
        if (offset < 0.0) {
            offset = 0.0;
        }
        if (offset > (max = circuitBounds - circuitBounds / (double)this.zoom)) {
            offset = max;
        }
        return offset;
    }

    public MicrochipViewPosition copy() {
        return new MicrochipViewPosition(this.x, this.y, this.zoom);
    }
}

