/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.gui.microchip.wire;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.ObjectHeapPriorityQueue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.swedz.little_big_redstone.microchip.Microchip;
import net.swedz.little_big_redstone.microchip.object.logic.LogicEntry;
import net.swedz.little_big_redstone.microchip.object.logic.config.LogicConfig;
import net.swedz.little_big_redstone.microchip.wire.Wire;
import net.swedz.tesseract.neoforge.api.Bounds;

public final class WirePathing {
    private final Microchip microchip;
    private final int areaPaddingXY;
    private final Function<Bounds, Bounds> componentBoundMutator;
    private final Map<Wire, List<Position>> paths = Maps.newHashMap();
    private static final int[][] NEIGHBOR_DIRECTIONS = new int[][]{{-1, 0}, {0, 1}, {1, 0}, {0, -1}};

    public WirePathing(Microchip microchip, int areaPaddingXY, Function<Bounds, Bounds> componentBoundMutator) {
        this.microchip = microchip;
        this.areaPaddingXY = areaPaddingXY;
        this.componentBoundMutator = componentBoundMutator;
    }

    public Bounds mutateComponentBounds(Bounds bounds) {
        return this.componentBoundMutator.apply(bounds);
    }

    public List<Position> get(Wire wire, int startX, int startY, int endX, int endY) {
        return wire == null ? this.build(startX, startY, endX, endY) : this.paths.computeIfAbsent(wire, __ -> this.build(startX, startY, endX, endY));
    }

    public List<Position> build(int startX, int startY, int endX, int endY, List<Bounds> avoidBounds) {
        avoidBounds = Lists.newArrayList(avoidBounds);
        for (LogicEntry entry : this.microchip.components()) {
            if (!((LogicConfig)entry.component().config()).isVisible()) continue;
            avoidBounds.add(this.mutateComponentBounds(entry.toBounds()));
        }
        return WirePathing.path(startX, startY, endX, endY, this.microchip, this.areaPaddingXY, avoidBounds);
    }

    public List<Position> build(int startX, int startY, int endX, int endY) {
        return this.build(startX, startY, endX, endY, List.of());
    }

    public boolean contains(Wire wire, int x, int y, int wireSectionSize, int wireSectionPadding) {
        List<Position> path = this.paths.get(wire);
        if (path != null) {
            for (Position position : path) {
                if (x < position.x - wireSectionPadding - 1 || x > position.x + wireSectionSize + wireSectionPadding - 1 || y < position.y - wireSectionPadding - 1 || y > position.y + wireSectionSize + wireSectionPadding - 1) continue;
                return true;
            }
        }
        return false;
    }

    public void forgetEverything() {
        this.paths.clear();
    }

    private static List<Position> path(int startX, int startY, int endX, int endY, Microchip microchip, int areaPaddingXY, List<Bounds> avoidBounds) {
        Bounds innerBounds = microchip.size().bounds().normalize();
        Bounds bounds = innerBounds.grow(areaPaddingXY, areaPaddingXY);
        NodeGrid nodes = new NodeGrid(bounds);
        Node start = nodes.get(startX, startY);
        Node end = nodes.get(endX, endY);
        if (start == null || end == null) {
            return List.of();
        }
        AvoidGrid avoidAreas = WirePathing.buildAvoidGrid(innerBounds, bounds, avoidBounds);
        ObjectHeapPriorityQueue open = new ObjectHeapPriorityQueue();
        open.enqueue((Object)start);
        start.open = true;
        while (!open.isEmpty()) {
            Node current = (Node)open.dequeue();
            if (current.closed) continue;
            current.open = false;
            if (current.equals(end)) {
                return WirePathing.retrace(current);
            }
            current.closed = true;
            for (Node neighbor : WirePathing.neighbors(nodes, current)) {
                boolean betterPath;
                if (neighbor == null || neighbor.closed) continue;
                int g = current.g + 1 + avoidAreas.getWeight(neighbor);
                boolean notOpen = !neighbor.open;
                boolean bl = betterPath = g < neighbor.g;
                if (!notOpen && !betterPath) continue;
                neighbor.g = g;
                neighbor.h = neighbor.distanceTo(end);
                neighbor.parent = current;
                if (!notOpen) continue;
                open.enqueue((Object)neighbor);
                neighbor.open = true;
            }
        }
        return List.of();
    }

    private static AvoidGrid buildAvoidGrid(Bounds innerBounds, Bounds bounds, List<Bounds> avoidBounds) {
        int mediumAvoidWeight = 160;
        int heavyAvoidWeight = 240;
        AvoidGrid avoidAreas = new AvoidGrid(bounds, mediumAvoidWeight);
        int index = Node.indexOf(bounds, innerBounds.minX(), innerBounds.minY());
        for (int y = innerBounds.minY(); y <= innerBounds.maxY(); ++y) {
            for (int x = innerBounds.minX(); x <= innerBounds.maxX(); ++x) {
                avoidAreas.setWeight(index, 0);
                ++index;
            }
            index += bounds.width() - innerBounds.width();
        }
        for (Bounds avoidBoundsEntry : avoidBounds) {
            index = Node.indexOf(bounds, avoidBoundsEntry.minX(), avoidBoundsEntry.minY());
            for (int y = avoidBoundsEntry.minY(); y <= avoidBoundsEntry.maxY(); ++y) {
                for (int x = avoidBoundsEntry.minX(); x <= avoidBoundsEntry.maxX(); ++x) {
                    avoidAreas.setWeight(index, heavyAvoidWeight);
                    ++index;
                }
                index += bounds.width() - avoidBoundsEntry.width();
            }
        }
        return avoidAreas;
    }

    private static Node[] neighbors(NodeGrid nodes, Node current) {
        Node[] neighbors = new Node[4];
        int index = 0;
        for (int[] direction : NEIGHBOR_DIRECTIONS) {
            int x = current.x + direction[0];
            int y = current.y + direction[1];
            neighbors[index] = nodes.get(x, y);
            ++index;
        }
        return neighbors;
    }

    private static List<Position> retrace(Node end) {
        ArrayList path = Lists.newArrayList();
        Node current = end;
        while (current != null) {
            path.add(current.immutable());
            current = current.parent;
        }
        Collections.reverse(path);
        return Collections.unmodifiableList(path);
    }

    public record Position(int x, int y) {
    }

    private static final class NodeGrid {
        private final Bounds bounds;
        private final Node[] nodes;

        public NodeGrid(Bounds bounds) {
            this.bounds = bounds;
            this.nodes = new Node[bounds.width() * bounds.height()];
        }

        public Node get(int x, int y) {
            int index = Node.indexOf(this.bounds, x, y);
            if (index < 0 || index >= this.nodes.length) {
                return null;
            }
            Node node = this.nodes[index];
            if (node == null) {
                this.nodes[index] = node = new Node(index, x, y);
            }
            return node;
        }
    }

    private static final class Node
    implements Comparable<Node> {
        private final int index;
        private final int x;
        private final int y;
        private int g;
        private int h;
        private Node parent;
        private boolean open;
        private boolean closed;

        public static int indexOf(Bounds bounds, int x, int y) {
            return bounds.relativeX(x) + bounds.relativeY(y) * bounds.width();
        }

        public Node(int index, int x, int y) {
            this.index = index;
            this.x = x;
            this.y = y;
        }

        public Node(Bounds bounds, int x, int y) {
            this(Node.indexOf(bounds, x, y), x, y);
        }

        public int f() {
            return this.g + this.h;
        }

        public int distanceTo(Node other) {
            int dx = Math.abs(this.x - other.x);
            int dy = Math.abs(this.y - other.y);
            return 10 * (dx + dy) + -6 * Math.min(dx, dy);
        }

        public Position immutable() {
            return new Position(this.x, this.y);
        }

        @Override
        public int compareTo(Node other) {
            return Integer.compare(this.f(), other.f());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Node other = (Node)o;
            return this.x == other.x && this.y == other.y;
        }

        public int hashCode() {
            return Objects.hash(this.x, this.y);
        }
    }

    private static final class AvoidGrid {
        private final Bounds bounds;
        private final int[] avoids;

        public AvoidGrid(Bounds bounds, int defaultValue) {
            this.bounds = bounds;
            this.avoids = new int[bounds.width() * bounds.height()];
            if (defaultValue != 0) {
                Arrays.fill(this.avoids, defaultValue);
            }
        }

        public void setWeight(int x, int y, int weight) {
            int index = Node.indexOf(this.bounds, x, y);
            this.setWeight(index, weight);
        }

        public void setWeight(int index, int weight) {
            if (index < 0 || index >= this.avoids.length) {
                return;
            }
            this.avoids[index] = weight;
        }

        public int getWeight(Node node) {
            return this.avoids[node.index];
        }
    }
}

