/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.gui.stickynote;

import net.minecraft.client.GameNarrator;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.DyeColor;
import net.swedz.little_big_redstone.client.StickyNoteViewRenderer;
import net.swedz.little_big_redstone.entity.stickynote.StickyNoteView;
import net.swedz.little_big_redstone.gui.stickynote.reference.StickyNoteReference;
import net.swedz.tesseract.neoforge.helper.guigraphics.TesseractGuiGraphics;

public abstract class StickyNoteScreen
extends Screen {
    protected final StickyNoteReference reference;
    protected final DyeColor color;
    protected final DyeColor textColor;
    protected final String initialText;
    protected int uiWidth;
    protected int uiHeight;
    protected int leftPos;
    protected int topPos;
    protected final int contentLeftPos;
    protected final int contentTopPos;
    protected final int maxContentWidth;
    protected final int maxContentHeight;

    protected StickyNoteScreen(StickyNoteReference reference) {
        super(GameNarrator.NO_TITLE);
        this.reference = reference;
        this.color = reference.color();
        this.textColor = reference.textColor();
        this.initialText = reference.text();
        this.uiWidth = 180;
        this.uiHeight = 214;
        this.contentLeftPos = 5;
        this.contentTopPos = 27;
        this.maxContentWidth = 170;
        this.maxContentHeight = 126;
    }

    protected void init() {
        this.leftPos = this.width / 2 - this.uiWidth / 2;
        this.topPos = this.height / 2 - this.uiHeight / 2;
    }

    public void renderBackground(GuiGraphics vanilla, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(vanilla, mouseX, mouseY, partialTick);
        TesseractGuiGraphics graphics = new TesseractGuiGraphics(vanilla);
        graphics.pose().pushPose();
        graphics.pose().translate((float)this.leftPos, (float)this.topPos, 0.0f);
        StickyNoteViewRenderer.renderBackground(graphics, new StickyNoteView(this.color, this.textColor, (Component)Component.empty()));
        graphics.pose().popPose();
    }
}

