/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.gui.stickynote.reference;

import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.swedz.little_big_redstone.gui.microchip.MicrochipMenu;
import net.swedz.little_big_redstone.gui.stickynote.reference.StickyNoteReference;
import net.swedz.little_big_redstone.item.stickynote.StickyNote;
import net.swedz.little_big_redstone.microchip.object.note.StickyNoteEntry;
import net.swedz.little_big_redstone.network.packet.StickyNotePacket;

public final class MicrochipStickyNoteReference
implements StickyNoteReference {
    private final int slot;
    private final DyeColor color;
    private final DyeColor textColor;
    private final String text;

    public MicrochipStickyNoteReference(StickyNoteEntry entry) {
        this(entry.slot(), entry.noteColor(), entry.textColor(), entry.note().text());
    }

    private MicrochipStickyNoteReference(int slot, DyeColor color, DyeColor textColor, String text) {
        this.slot = slot;
        this.color = color;
        this.textColor = textColor;
        this.text = text;
    }

    @Override
    public DyeColor color() {
        return this.color;
    }

    @Override
    public DyeColor textColor() {
        return this.textColor;
    }

    @Override
    public String text() {
        return this.text;
    }

    @Override
    public StickyNoteReference withText(String text) {
        return new MicrochipStickyNoteReference(this.slot, this.color, this.textColor, text);
    }

    private void save(Player player) {
        StickyNoteEntry entry;
        MicrochipMenu menu;
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof MicrochipMenu && (menu = (MicrochipMenu)abstractContainerMenu).stillValid(player) && (entry = (StickyNoteEntry)menu.microchip().stickyNotes().get(this.slot)) != null) {
            entry.setNote(new StickyNote(this.text));
            menu.microchip().markDirty();
        }
    }

    @Override
    public void saveClient(Level level, Player player) {
        this.save(player);
        new StickyNotePacket(StickyNotePacket.ReferenceType.MICROCHIP, this.slot, StickyNotePacket.Action.DONE_EDIT, this.text).sendToServer();
    }

    @Override
    public void saveServer(Level level, Player player) {
        this.save(player);
    }

    @Override
    public boolean isStillValid(Level level, Player player) {
        MicrochipMenu menu;
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        return abstractContainerMenu instanceof MicrochipMenu && (menu = (MicrochipMenu)abstractContainerMenu).stillValid(player) && menu.microchip().stickyNotes().get(this.slot) != null;
    }
}

