/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.guide;

import guideme.Guide;
import guideme.compiler.PageCompiler;
import guideme.compiler.TagCompiler;
import guideme.compiler.tags.BoxFlowDirection;
import guideme.compiler.tags.MdxAttrs;
import guideme.document.LytErrorSink;
import guideme.extensions.Extension;
import guideme.libs.mdast.mdx.model.MdxJsxElementFields;
import guideme.libs.unist.UnistNode;
import guideme.scene.ImplicitAnnotationStrategy;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.swedz.little_big_redstone.LBR;
import net.swedz.little_big_redstone.guide.tags.block.FloatingBoxTagCompiler;
import net.swedz.little_big_redstone.guide.tags.block.LogicIndexTagCompiler;
import net.swedz.little_big_redstone.guide.tags.block.MarginFloatingImageCompiler;
import net.swedz.little_big_redstone.guide.tags.block.PaddedBoxTagCompiler;
import net.swedz.little_big_redstone.guide.tags.microchip.MicrochipSceneTagCompiler;
import net.swedz.little_big_redstone.guide.tags.microchip.element.LogicElementTagCompiler;
import net.swedz.little_big_redstone.guide.tags.microchip.element.MicrochipSceneElementTagCompiler;
import net.swedz.little_big_redstone.guide.tags.microchip.element.RedstoneSignalTagCompiler;
import net.swedz.little_big_redstone.guide.tags.microchip.element.WireElementTagCompiler;
import net.swedz.little_big_redstone.guide.tags.scene.InputOutputImplicitAnnotationStrategy;
import net.swedz.little_big_redstone.guide.tags.text.UnderlinedTextTagCompiler;
import net.swedz.little_big_redstone.guide.tags.truthtable.TruthTableTagCompiler;
import net.swedz.little_big_redstone.guide.tags.truthtable.element.TruthTableElementTagCompiler;
import net.swedz.little_big_redstone.guide.tags.truthtable.element.TruthTableStateTagCompiler;
import net.swedz.little_big_redstone.microchip.object.logic.LogicType;
import net.swedz.little_big_redstone.microchip.object.logic.LogicTypes;

public final class LBRGuide {
    public static void init() {
        Guide.builder((ResourceLocation)LBR.id("guide")).folder("guide").extension(TagCompiler.EXTENSION_POINT, (Extension)new UnderlinedTextTagCompiler()).extension(TagCompiler.EXTENSION_POINT, (Extension)new PaddedBoxTagCompiler()).extension(TagCompiler.EXTENSION_POINT, (Extension)new MarginFloatingImageCompiler()).extension(TagCompiler.EXTENSION_POINT, (Extension)new LogicIndexTagCompiler()).extension(TagCompiler.EXTENSION_POINT, (Extension)new MicrochipSceneTagCompiler()).extension(MicrochipSceneElementTagCompiler.EXTENSION_POINT, (Extension)new LogicElementTagCompiler()).extension(MicrochipSceneElementTagCompiler.EXTENSION_POINT, (Extension)new WireElementTagCompiler()).extension(MicrochipSceneElementTagCompiler.EXTENSION_POINT, (Extension)new RedstoneSignalTagCompiler()).extension(TagCompiler.EXTENSION_POINT, (Extension)new TruthTableTagCompiler()).extension(TruthTableElementTagCompiler.EXTENSION_POINT, (Extension)new TruthTableStateTagCompiler()).extension(TagCompiler.EXTENSION_POINT, (Extension)new FloatingBoxTagCompiler(BoxFlowDirection.ROW)).extension(TagCompiler.EXTENSION_POINT, (Extension)new FloatingBoxTagCompiler(BoxFlowDirection.COLUMN)).extension(ImplicitAnnotationStrategy.EXTENSION_POINT, (Extension)new InputOutputImplicitAnnotationStrategy()).build();
    }

    public static DyeColor getDyeColor(PageCompiler compiler, LytErrorSink errorSink, MdxJsxElementFields el, String name, DyeColor defaultColor) {
        String rawColor = MdxAttrs.getString((PageCompiler)compiler, (LytErrorSink)errorSink, (MdxJsxElementFields)el, (String)name, null);
        if (rawColor != null) {
            try {
                return DyeColor.valueOf((String)rawColor.toUpperCase());
            }
            catch (IllegalArgumentException ignored) {
                errorSink.appendError(compiler, "Color must be a valid dye color", (UnistNode)el);
                return defaultColor;
            }
        }
        return defaultColor;
    }

    public static LogicType<?> getLogicType(PageCompiler compiler, LytErrorSink errorSink, MdxJsxElementFields el, String name) {
        String logicId = MdxAttrs.getString((PageCompiler)compiler, (LytErrorSink)errorSink, (MdxJsxElementFields)el, (String)name, null);
        if (logicId != null) {
            try {
                return LogicTypes.get(logicId.toLowerCase());
            }
            catch (Exception ignored) {
                errorSink.appendError(compiler, "Logic type does not exist", (UnistNode)el);
                return null;
            }
        }
        return null;
    }

    public static String[] getStringArray(PageCompiler compiler, LytErrorSink errorSink, MdxJsxElementFields el, String name) {
        String rawInts = MdxAttrs.getString((PageCompiler)compiler, (LytErrorSink)errorSink, (MdxJsxElementFields)el, (String)name, null);
        if (rawInts != null) {
            return rawInts.split(",");
        }
        return null;
    }
}

