/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.guide.tags.microchip;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import guideme.compiler.IndexingContext;
import guideme.compiler.IndexingSink;
import guideme.compiler.PageCompiler;
import guideme.compiler.tags.BlockTagCompiler;
import guideme.compiler.tags.MdxAttrs;
import guideme.document.LytErrorSink;
import guideme.document.block.LytBlock;
import guideme.document.block.LytBlockContainer;
import guideme.extensions.ExtensionCollection;
import guideme.libs.mdast.mdx.model.MdxJsxElementFields;
import guideme.libs.mdast.model.MdAstAnyContent;
import guideme.libs.unist.UnistNode;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.item.DyeColor;
import net.swedz.little_big_redstone.guide.LBRGuide;
import net.swedz.little_big_redstone.guide.tags.microchip.MicrochipGuidebookScene;
import net.swedz.little_big_redstone.guide.tags.microchip.element.MicrochipSceneElementTagCompiler;

public final class MicrochipSceneTagCompiler
extends BlockTagCompiler {
    private final Map<String, MicrochipSceneElementTagCompiler> elementTagCompilers = Maps.newHashMap();

    public Set<String> getTagNames() {
        return Set.of("MicrochipScene");
    }

    protected void compile(PageCompiler compiler, LytBlockContainer parent, MdxJsxElementFields el) {
        int padding = MdxAttrs.getInt((PageCompiler)compiler, (LytErrorSink)parent, (MdxJsxElementFields)el, (String)"padding", (int)5);
        int width = MdxAttrs.getInt((PageCompiler)compiler, (LytErrorSink)parent, (MdxJsxElementFields)el, (String)"width", (int)-1);
        int height = MdxAttrs.getInt((PageCompiler)compiler, (LytErrorSink)parent, (MdxJsxElementFields)el, (String)"height", (int)-1);
        int marginWidth = MdxAttrs.getInt((PageCompiler)compiler, (LytErrorSink)parent, (MdxJsxElementFields)el, (String)"marginWidth", (int)(width == -1 ? 10 : 0));
        int marginHeight = MdxAttrs.getInt((PageCompiler)compiler, (LytErrorSink)parent, (MdxJsxElementFields)el, (String)"marginHeight", (int)(height == -1 ? 10 : 0));
        DyeColor color = LBRGuide.getDyeColor(compiler, (LytErrorSink)parent, el, "color", DyeColor.RED);
        boolean includeToolbar = MdxAttrs.getBoolean((PageCompiler)compiler, (LytErrorSink)parent, (MdxJsxElementFields)el, (String)"includeToolbar", (boolean)false);
        MicrochipGuidebookScene block = new MicrochipGuidebookScene(color, width, height, marginWidth, marginHeight, includeToolbar);
        HashSet delayedChildren = Sets.newHashSet();
        for (MdAstAnyContent child : el.children()) {
            if (!(child instanceof MdxJsxElementFields)) continue;
            MdxJsxElementFields childEl = (MdxJsxElementFields)child;
            String childTagName = childEl.name();
            MicrochipSceneElementTagCompiler childCompiler = this.elementTagCompilers.get(childTagName);
            if (childCompiler == null) {
                parent.appendError(compiler, "Unknown microchip scene element", (UnistNode)child);
                continue;
            }
            if (childCompiler.isDelayed()) {
                delayedChildren.add(childEl);
                continue;
            }
            childCompiler.compile(block, compiler, (LytErrorSink)parent, childEl);
        }
        block.adjustSize();
        for (MdxJsxElementFields childEl : delayedChildren) {
            String childTagName = childEl.name();
            MicrochipSceneElementTagCompiler childCompiler = this.elementTagCompilers.get(childTagName);
            childCompiler.compile(block, compiler, (LytErrorSink)parent, childEl);
        }
        block.setPadding(padding);
        parent.append((LytBlock)block);
    }

    public void onExtensionsBuilt(ExtensionCollection extensions) {
        for (MicrochipSceneElementTagCompiler sceneElementTag : extensions.get(MicrochipSceneElementTagCompiler.EXTENSION_POINT)) {
            for (String tagName : sceneElementTag.getTagNames()) {
                this.elementTagCompilers.put(tagName, sceneElementTag);
            }
        }
    }

    public void index(IndexingContext indexer, MdxJsxElementFields el, IndexingSink sink) {
    }
}

