/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.network.packet;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.swedz.little_big_redstone.LBR;
import net.swedz.little_big_redstone.entity.stickynote.StickyNoteEntity;
import net.swedz.little_big_redstone.network.LBRCustomPacket;
import net.swedz.little_big_redstone.network.packet.PickStickyNoteResponsePacket;
import net.swedz.tesseract.neoforge.packet.PacketContext;

public record PickStickyNotePacket(int entityId, boolean includeData) implements LBRCustomPacket
{
    public static final StreamCodec<ByteBuf, PickStickyNotePacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, PickStickyNotePacket::entityId, (StreamCodec)ByteBufCodecs.BOOL, PickStickyNotePacket::includeData, PickStickyNotePacket::new);

    public void handle(PacketContext context) {
        context.assertServerbound();
        ServerPlayer player = (ServerPlayer)context.getPlayer();
        String playerName = player.getGameProfile().getName();
        Level level = player.level();
        if (player.getAbilities().instabuild) {
            Entity entity = level.getEntity(this.entityId);
            if (entity instanceof StickyNoteEntity) {
                StickyNoteEntity entity2 = (StickyNoteEntity)entity;
                ItemStack stack = entity2.asItem(this.includeData);
                new PickStickyNoteResponsePacket(stack).sendToClient(player);
            } else {
                LBR.LOGGER.warn("Received PickStickyNotePacket from {} targeting an entity id that is not a sticky note, discarding", (Object)playerName);
            }
        } else {
            LBR.LOGGER.warn("Received PickStickyNotePacket from {} while not in creative mode, discarding", (Object)playerName);
        }
    }
}

