/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.common.book.BookRegistry;

public class OpenBookCommand {
    private static final SuggestionProvider<CommandSourceStack> BOOK_ID_SUGGESTER = (ctx, builder) -> SharedSuggestionProvider.suggestResource(BookRegistry.INSTANCE.books.keySet(), (SuggestionsBuilder)builder);

    public static void register(CommandDispatcher<CommandSourceStack> disp) {
        disp.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"open-patchouli-book").requires(cs -> cs.hasPermission(2))).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(((RequiredArgumentBuilder)Commands.argument((String)"book", (ArgumentType)ResourceLocationArgument.id()).suggests(BOOK_ID_SUGGESTER).executes(ctx -> OpenBookCommand.doIt(EntityArgument.getPlayers((CommandContext)ctx, (String)"targets"), ResourceLocationArgument.getId((CommandContext)ctx, (String)"book"), null, 0))).then(Commands.argument((String)"entry", (ArgumentType)ResourceLocationArgument.id()).then(Commands.argument((String)"page", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> OpenBookCommand.doIt(EntityArgument.getPlayers((CommandContext)ctx, (String)"targets"), ResourceLocationArgument.getId((CommandContext)ctx, (String)"book"), ResourceLocationArgument.getId((CommandContext)ctx, (String)"entry"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page"))))))));
    }

    private static int doIt(Collection<ServerPlayer> players, ResourceLocation book, @Nullable ResourceLocation entry, int page) {
        for (ServerPlayer player : players) {
            if (entry != null) {
                PatchouliAPI.get().openBookEntry(player, book, entry, page);
                continue;
            }
            PatchouliAPI.get().openBookGUI(player, book);
        }
        return players.size();
    }
}

