/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.fastsuite;

import dev.shadowsoffire.fastsuite.CachedRecipeList;
import dev.shadowsoffire.fastsuite.FastSuite;
import dev.shadowsoffire.fastsuite.ILockableItemStack;
import dev.shadowsoffire.fastsuite.StreamUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.VisibleForTesting;

public class AuxRecipeManager
extends RecipeManager {
    private final Map<RecipeType<?>, CachedRecipeList<?, ?>> cachedRecipeListMap = new HashMap();

    public AuxRecipeManager(HolderLookup.Provider registries) {
        super(registries);
    }

    @VisibleForTesting
    public <C extends RecipeInput, T extends Recipe<C>> Optional<RecipeHolder<T>> super_getRecipeFor(RecipeType<T> type, C inv, Level level) {
        return super.getRecipeFor(type, inv, level);
    }

    public <C extends RecipeInput, T extends Recipe<C>> Optional<RecipeHolder<T>> getRecipeFor(RecipeType<T> type, C inv, Level level, @Nullable RecipeHolder<T> lastRecipe) {
        if (this.numRecipesOf(type) < 100 || FastSuite.singleThreadedLookups.contains(type)) {
            return super.getRecipeFor(type, inv, level, lastRecipe);
        }
        if (lastRecipe != null && lastRecipe.value().matches(inv, level)) {
            return Optional.of(lastRecipe);
        }
        this.lockAllStacks(inv, true);
        try {
            if (FastSuite.unsafeMode) {
                Optional<RecipeHolder<T>> optional = StreamUtils.executeUntil(() -> this.byType(type).parallelStream().filter(recipe -> recipe.value().matches(inv, level)).findFirst(), FastSuite.maxRecipeLookupTime, TimeUnit.SECONDS, Optional.empty(), () -> CachedRecipeList.timeoutMsg(type));
                return optional;
            }
            CachedRecipeList<C, T> cachedRecipeList = this.getCachedRecipeList(type);
            Optional<RecipeHolder<T>> out = cachedRecipeList.getRecipeFor(inv, level);
            if (FastSuite.DEBUG_MATCHING) {
                FastSuite.LOGGER.info("Matched recipe: " + String.valueOf(out) + " for input " + String.valueOf(inv));
            }
            Optional<RecipeHolder<T>> optional = out;
            return optional;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.lockAllStacks(inv, false);
        }
    }

    public <C extends RecipeInput, T extends Recipe<C>> List<RecipeHolder<T>> getRecipesFor(RecipeType<T> type, C inv, Level level) {
        if (this.numRecipesOf(type) < 100 || FastSuite.singleThreadedLookups.contains(type)) {
            return super.getRecipesFor(type, inv, level);
        }
        this.lockAllStacks(inv, true);
        try {
            if (FastSuite.unsafeMode) {
                List<RecipeHolder<T>> list = StreamUtils.executeUntil(() -> this.byType(type).parallelStream().filter(recipe -> recipe.value().matches(inv, level)).sorted(Comparator.comparing(recipe -> recipe.value().getResultItem((HolderLookup.Provider)level.registryAccess()).getDescriptionId())).collect(Collectors.toList()), FastSuite.maxRecipeLookupTime, TimeUnit.SECONDS, Collections.emptyList(), () -> CachedRecipeList.timeoutMsg(type));
                return list;
            }
            CachedRecipeList<C, T> cachedRecipeList = this.getCachedRecipeList(type);
            List<RecipeHolder<T>> list = cachedRecipeList.getRecipesFor(inv, level);
            return list;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.lockAllStacks(inv, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <C extends RecipeInput, T extends Recipe<C>> CachedRecipeList<C, T> getCachedRecipeList(RecipeType<T> type) {
        Map<RecipeType<?>, CachedRecipeList<?, ?>> map = this.cachedRecipeListMap;
        synchronized (map) {
            CachedRecipeList<Object, Object> list = this.cachedRecipeListMap.get(type);
            if (list == null) {
                list = new CachedRecipeList(type, this.byType(type));
                this.cachedRecipeListMap.put(type, list);
            }
            return list;
        }
    }

    private <C extends RecipeInput> void lockAllStacks(C inv, boolean locked) {
        if (FastSuite.lockInputStacks) {
            for (int i = 0; i < inv.size(); ++i) {
                ItemStack s = inv.getItem(i);
                if (s.isEmpty()) continue;
                ((ILockableItemStack)s).setLocked(locked);
            }
        }
    }

    private int numRecipesOf(RecipeType type) {
        return this.byType(type).size();
    }
}

