/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.common.block;

import com.github.jarva.arsadditions.common.block.tile.EnderSourceJarTile;
import com.github.jarva.arsadditions.common.util.FillUtil;
import com.github.jarva.arsadditions.server.storage.EnderSourceData;
import com.hollingsworth.arsnouveau.common.block.ITickableBlock;
import com.hollingsworth.arsnouveau.common.block.SourceJar;
import com.hollingsworth.arsnouveau.common.block.TickableModBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnderSourceJar
extends SourceJar
implements ITickableBlock {
    public EnderSourceJar() {
        super(TickableModBlock.defaultProperties().noOcclusion(), "ender_source_jar");
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new EnderSourceJarTile(pos, state);
    }

    @NotNull
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState bs = super.getStateForPlacement(context);
        if (context.getPlayer() == null || context.getLevel().isClientSide) {
            return bs;
        }
        int source = EnderSourceData.getSource(context.getLevel().getServer(), context.getPlayer().getUUID());
        if (source == 0) {
            return bs;
        }
        int fill = FillUtil.getFillState(source);
        return (BlockState)bs.setValue(SourceJar.fill, (Comparable)Integer.valueOf(fill));
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        if (placer == null) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof EnderSourceJarTile) {
            EnderSourceJarTile jar = (EnderSourceJarTile)blockEntity;
            jar.setOwner(placer.getUUID());
        }
    }
}

