/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.datagen.recipes;

import com.github.jarva.arsadditions.ArsAdditions;
import com.github.jarva.arsadditions.common.recipe.SourceSpawnerRecipe;
import com.github.jarva.arsadditions.common.util.codec.ResourceOrTag;
import com.github.jarva.arsadditions.common.util.codec.TagModifier;
import com.github.jarva.arsadditions.datagen.tags.EntityTypeTagDatagen;
import com.github.jarva.arsadditions.setup.registry.AddonRecipeRegistry;
import com.github.jarva.arsadditions.setup.registry.ModifyTagRegistry;
import com.google.gson.JsonElement;
import com.hollingsworth.arsnouveau.common.datagen.SimpleDataProvider;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.entity.EntityType;

public class SourceSpawnerProvider
extends SimpleDataProvider {
    public List<SourceSpawnerRecipe> recipes = new ArrayList<SourceSpawnerRecipe>();

    public SourceSpawnerProvider(DataGenerator generatorIn) {
        super(generatorIn);
    }

    public void collectJsons(CachedOutput pOutput) {
        this.addEntries();
        for (SourceSpawnerRecipe recipe : this.recipes) {
            Path path = SourceSpawnerProvider.getRecipePath(this.output, AddonRecipeRegistry.SOURCE_SPAWNER_TYPE.getId().getPath());
            SourceSpawnerRecipe.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)recipe).result().ifPresent(json -> this.saveStable(pOutput, (JsonElement)json, path));
        }
    }

    protected void addEntries() {
        this.addEntry("default", new ModifyTagRegistry.RemoveGuaranteedDrops(), new ModifyTagRegistry.RemoveTag(List.of("Inventory", "Items")));
        this.addEntry("blacklist", ResourceOrTag.tag(EntityTypeTagDatagen.SOURCE_SPAWNER_NBT_BLACKLIST), null, List.of(new ModifyTagRegistry.RemoveTag(List.of())));
    }

    private void addEntry(String id, EntityType<?> entityType, TagModifier ... tagModifiers) {
        this.addEntry(id, ResourceOrTag.key(entityType.builtInRegistryHolder().key()), null, List.of(tagModifiers));
    }

    private void addEntry(String id, TagModifier ... tagModifiers) {
        this.addEntry(id, null, null, List.of(tagModifiers));
    }

    private void addEntry(String id, ResourceOrTag<EntityType<?>> entity, Integer source, List<TagModifier> tagModifiers) {
        this.recipes.add(new SourceSpawnerRecipe(ArsAdditions.prefix(id), Optional.ofNullable(entity), Optional.ofNullable(source), Optional.ofNullable(tagModifiers)));
    }

    protected static Path getRecipePath(Path path, String id) {
        return path.resolve("data/ars_additions/recipe/source_spawner/" + id + ".json");
    }

    public String getName() {
        return "Source Spawner Datagen";
    }
}

