/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.container.IAuraContainer;
import de.ellpeck.naturesaura.blocks.ModBlocks;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityAncientLeaves;
import de.ellpeck.naturesaura.data.BlockStateGenerator;
import de.ellpeck.naturesaura.reg.IColorProvidingBlock;
import de.ellpeck.naturesaura.reg.IColorProvidingItem;
import de.ellpeck.naturesaura.reg.ICustomBlockState;
import de.ellpeck.naturesaura.reg.IModItem;
import de.ellpeck.naturesaura.reg.ModRegistry;
import de.ellpeck.naturesaura.reg.ModTileType;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import org.jetbrains.annotations.Nullable;

public class BlockAncientLeaves
extends LeavesBlock
implements IModItem,
IColorProvidingBlock,
IColorProvidingItem,
ICustomBlockState,
EntityBlock {
    public BlockAncientLeaves() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PINK).strength(0.2f).randomTicks().noOcclusion().sound(SoundType.GRASS));
        ModRegistry.ALL_ITEMS.add(this);
        ModRegistry.ALL_ITEMS.add(new ModTileType(BlockEntityAncientLeaves::new, this));
    }

    @Override
    public String getBaseName() {
        return "ancient_leaves";
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public BlockColor getBlockColor() {
        return (state, levelIn, pos, tintIndex) -> 15031191;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ItemColor getItemColor() {
        return (stack, tintIndex) -> 15031191;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState stateIn, Level levelIn, BlockPos pos, RandomSource rand) {
        IAuraContainer container;
        BlockEntity tile;
        super.animateTick(stateIn, levelIn, pos, rand);
        if (rand.nextFloat() >= 0.95f && !levelIn.getBlockState(pos.below()).isCollisionShapeFullBlock((BlockGetter)levelIn, pos) && (tile = levelIn.getBlockEntity(pos)) instanceof BlockEntityAncientLeaves && (container = (IAuraContainer)levelIn.getCapability(NaturesAuraAPI.AURA_CONTAINER_BLOCK_CAPABILITY, tile.getBlockPos(), tile.getBlockState(), tile, null)).getStoredAura() > 0) {
            NaturesAuraAPI.instance().spawnMagicParticle((double)pos.getX() + rand.nextDouble(), pos.getY(), (double)pos.getZ() + rand.nextDouble(), 0.0, 0.0, 0.0, 13387648, rand.nextFloat() * 2.0f + 0.5f, rand.nextInt(50) + 75, rand.nextFloat() * 0.02f + 0.002f, true, true);
        }
    }

    public void randomTick(BlockState state, ServerLevel levelIn, BlockPos pos, RandomSource random) {
        IAuraContainer container;
        BlockEntity tile;
        super.randomTick(state, levelIn, pos, random);
        if (!levelIn.isClientSide && (tile = levelIn.getBlockEntity(pos)) instanceof BlockEntityAncientLeaves && (container = (IAuraContainer)levelIn.getCapability(NaturesAuraAPI.AURA_CONTAINER_BLOCK_CAPABILITY, tile.getBlockPos(), tile.getBlockState(), tile, null)).getStoredAura() <= 0) {
            levelIn.setBlockAndUpdate(pos, ModBlocks.DECAYED_LEAVES.defaultBlockState());
        }
    }

    public boolean isRandomlyTicking(BlockState state) {
        return true;
    }

    @Override
    public void generateCustomBlockState(BlockStateGenerator generator) {
        generator.simpleBlock((Block)this, (ModelFile)generator.models().getExistingFile(generator.modLoc(this.getBaseName())));
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BlockEntityAncientLeaves(pos, state);
    }
}

