/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.blocks.BlockAncientLeaves;
import de.ellpeck.naturesaura.blocks.ModBlocks;
import de.ellpeck.naturesaura.data.BlockStateGenerator;
import de.ellpeck.naturesaura.reg.IColorProvidingBlock;
import de.ellpeck.naturesaura.reg.IColorProvidingItem;
import de.ellpeck.naturesaura.reg.ICustomBlockState;
import de.ellpeck.naturesaura.reg.IModItem;
import de.ellpeck.naturesaura.reg.ModRegistry;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.model.generators.ModelFile;

public class BlockGoldenLeaves
extends LeavesBlock
implements IModItem,
IColorProvidingBlock,
IColorProvidingItem,
ICustomBlockState {
    public static final int HIGHEST_STAGE = 3;
    public static final IntegerProperty STAGE = IntegerProperty.create((String)"stage", (int)0, (int)3);

    public BlockGoldenLeaves() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.GOLD).strength(0.2f).randomTicks().noOcclusion().sound(SoundType.GRASS));
        ModRegistry.ALL_ITEMS.add(this);
    }

    public static boolean convert(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        if (state.getBlock() instanceof LeavesBlock && !(state.getBlock() instanceof BlockAncientLeaves) && !(state.getBlock() instanceof BlockGoldenLeaves)) {
            if (!level.isClientSide) {
                level.setBlockAndUpdate(pos, (BlockState)((BlockState)ModBlocks.GOLDEN_LEAVES.defaultBlockState().setValue((Property)LeavesBlock.DISTANCE, (Comparable)(state.hasProperty((Property)LeavesBlock.DISTANCE) ? (Integer)state.getValue((Property)LeavesBlock.DISTANCE) : Integer.valueOf(1)))).setValue((Property)LeavesBlock.PERSISTENT, (Comparable)(state.hasProperty((Property)LeavesBlock.PERSISTENT) ? (Boolean)state.getValue((Property)LeavesBlock.PERSISTENT) : Boolean.valueOf(false))));
            }
            return true;
        }
        return false;
    }

    @Override
    public String getBaseName() {
        return "golden_leaves";
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState stateIn, Level levelIn, BlockPos pos, RandomSource rand) {
        if ((Integer)stateIn.getValue((Property)STAGE) == 3 && rand.nextFloat() >= 0.75f) {
            NaturesAuraAPI.instance().spawnMagicParticle((float)pos.getX() + rand.nextFloat(), (float)pos.getY() + rand.nextFloat(), (float)pos.getZ() + rand.nextFloat(), 0.0, 0.0, 0.0, 0xF2FF00, 0.5f + rand.nextFloat(), 50, 0.0f, false, true);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{STAGE});
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public BlockColor getBlockColor() {
        return (state, levelIn, pos, tintIndex) -> {
            int color = 0xF2FF00;
            if (state != null && levelIn != null && pos != null) {
                int foliage = BiomeColors.getAverageFoliageColor((BlockAndTintGetter)levelIn, (BlockPos)pos);
                return Helper.blendColors(color, foliage, (float)((Integer)state.getValue((Property)STAGE)).intValue() / 3.0f);
            }
            return color;
        };
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ItemColor getItemColor() {
        return (stack, tintIndex) -> 0xF2FF00;
    }

    public void randomTick(BlockState state, ServerLevel levelIn, BlockPos pos, RandomSource random) {
        super.randomTick(state, levelIn, pos, random);
        if (!levelIn.isClientSide) {
            BlockPos offset;
            int stage = (Integer)state.getValue((Property)STAGE);
            if (stage < 3) {
                levelIn.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)STAGE, (Comparable)Integer.valueOf(stage + 1)));
            }
            if (stage > 1 && levelIn.isLoaded(offset = pos.relative(Direction.getRandom((RandomSource)random)))) {
                BlockGoldenLeaves.convert((Level)levelIn, offset);
            }
        }
    }

    public boolean isRandomlyTicking(BlockState p_54449_) {
        return true;
    }

    @Override
    public void generateCustomBlockState(BlockStateGenerator generator) {
        generator.simpleBlock((Block)this, (ModelFile)generator.models().getExistingFile(generator.modLoc(this.getBaseName())));
    }
}

