/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.blocks.tiles.BlockEntityImpl;
import de.ellpeck.naturesaura.blocks.tiles.ITickableBlockEntity;
import de.ellpeck.naturesaura.blocks.tiles.ModBlockEntities;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class BlockEntityAnimalContainer
extends BlockEntityImpl
implements ITickableBlockEntity {
    public BlockEntityAnimalContainer(BlockPos pos, BlockState state) {
        super(ModBlockEntities.ANIMAL_CONTAINER, pos, state);
    }

    public int getRadius() {
        return this.redstonePower / 2;
    }

    @Override
    public void onRedstonePowerChange(int newPower) {
        super.onRedstonePowerChange(newPower);
        this.sendToClients();
    }

    @Override
    public void tick() {
        if (this.level.isClientSide) {
            return;
        }
        int radius = this.getRadius();
        HashSet animalsInRange = new HashSet(this.level.getEntitiesOfClass(Animal.class, new AABB(this.worldPosition).inflate((double)(radius - 1))));
        List animalsOutRange = this.level.getEntitiesOfClass(Animal.class, new AABB(this.worldPosition).inflate((double)(radius + 1)));
        for (Animal animal : animalsOutRange) {
            if (animalsInRange.contains(animal)) continue;
            Vec3 pos = animal.position();
            Vec3 distance = pos.subtract((double)this.worldPosition.getX(), pos.y, (double)this.worldPosition.getZ());
            distance = distance.normalize().scale((double)-0.15f);
            animal.setDeltaMovement(distance);
            if (!this.level.random.nextBoolean()) continue;
            Vec3 eye = animal.getEyePosition(1.0f).add(animal.getLookAngle());
            PacketHandler.sendToAllAround(this.level, this.worldPosition, 32, new PacketParticles((float)eye.x, (float)eye.y, (float)eye.z, PacketParticles.Type.ANIMAL_CONTAINER, new int[0]));
        }
    }
}

