/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.blocks.BlockGratedChute;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityImpl;
import de.ellpeck.naturesaura.blocks.tiles.ITickableBlockEntity;
import de.ellpeck.naturesaura.blocks.tiles.ItemStackHandlerNA;
import de.ellpeck.naturesaura.blocks.tiles.ModBlockEntities;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public class BlockEntityGratedChute
extends BlockEntityImpl
implements ITickableBlockEntity {
    public boolean isBlacklist;
    public final ItemStackHandlerNA items = new ItemStackHandlerNA(1, this, true){

        @Override
        protected boolean canExtract(ItemStack stack, int slot, int amount) {
            return BlockEntityGratedChute.this.redstonePower <= 0;
        }

        @Override
        protected boolean canInsert(ItemStack stack, int slot) {
            return BlockEntityGratedChute.this.isBlacklist != BlockEntityGratedChute.this.isItemInFrame(stack);
        }
    };
    private int cooldown;

    public BlockEntityGratedChute(BlockPos pos, BlockState state) {
        super(ModBlockEntities.GRATED_CHUTE, pos, state);
    }

    @Override
    public void tick() {
        block12: {
            if (!this.level.isClientSide) {
                if (this.cooldown <= 0) {
                    IItemHandler handler;
                    BlockState state;
                    Object facing;
                    BlockEntity tile;
                    this.cooldown = 6;
                    if (this.redstonePower > 0) {
                        return;
                    }
                    ItemStack curr = this.items.getStackInSlot(0);
                    if (!curr.isEmpty() && (tile = this.level.getBlockEntity(this.worldPosition.relative((Direction)(facing = (Direction)(state = this.level.getBlockState(this.worldPosition)).getValue((Property)BlockGratedChute.FACING))))) != null && (handler = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, tile.getBlockPos(), tile.getBlockState(), tile, (Object)facing.getOpposite())) != null) {
                        for (int i = 0; i < handler.getSlots(); ++i) {
                            ItemStack left;
                            ItemStack theoreticalDrain = this.items.extractItem(0, 1, true);
                            if (theoreticalDrain.isEmpty() || !(left = handler.insertItem(i, theoreticalDrain, false)).isEmpty()) continue;
                            this.items.extractItem(0, 1, false);
                            break;
                        }
                    }
                    if (curr.isEmpty() || curr.getCount() < curr.getMaxStackSize()) {
                        IItemHandler handlerUp;
                        List items = this.level.getEntitiesOfClass(ItemEntity.class, new AABB((double)this.worldPosition.getX(), (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ(), (double)(this.worldPosition.getX() + 1), (double)(this.worldPosition.getY() + 2), (double)(this.worldPosition.getZ() + 1)));
                        for (ItemEntity item : items) {
                            ItemStack left;
                            ItemStack stack;
                            if (!item.isAlive() || (stack = item.getItem()).isEmpty() || ItemStack.matches((ItemStack)stack, (ItemStack)(left = this.items.insertItem(0, stack, false)))) continue;
                            if (left.isEmpty()) {
                                item.kill();
                            } else {
                                item.setItem(left);
                            }
                            break block12;
                        }
                        BlockEntity tileUp = this.level.getBlockEntity(this.worldPosition.above());
                        if (tileUp != null && (handlerUp = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, tileUp.getBlockPos(), tileUp.getBlockState(), tileUp, (Object)Direction.DOWN)) != null) {
                            for (int i = 0; i < handlerUp.getSlots(); ++i) {
                                ItemStack left;
                                ItemStack theoreticalDrain = handlerUp.extractItem(i, 1, true);
                                if (theoreticalDrain.isEmpty() || !(left = this.items.insertItem(0, theoreticalDrain, false)).isEmpty()) continue;
                                handlerUp.extractItem(i, 1, false);
                                break;
                            }
                        }
                    }
                } else {
                    --this.cooldown;
                }
            }
        }
    }

    private boolean isItemInFrame(ItemStack stack) {
        List<ItemFrame> frames = Helper.getAttachedItemFrames(this.level, this.worldPosition);
        if (frames.isEmpty()) {
            return false;
        }
        for (ItemFrame frame : frames) {
            ItemStack frameStack = frame.getItem();
            if (!Helper.areItemsEqual(stack, frameStack, true)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void writeNBT(CompoundTag compound, BlockEntityImpl.SaveType type, HolderLookup.Provider registries) {
        super.writeNBT(compound, type, registries);
        if (type != BlockEntityImpl.SaveType.BLOCK) {
            compound.putInt("cooldown", this.cooldown);
            compound.put("items", (Tag)this.items.serializeNBT(registries));
            compound.putBoolean("blacklist", this.isBlacklist);
        }
    }

    @Override
    public void readNBT(CompoundTag compound, BlockEntityImpl.SaveType type, HolderLookup.Provider registries) {
        super.readNBT(compound, type, registries);
        if (type != BlockEntityImpl.SaveType.BLOCK) {
            this.cooldown = compound.getInt("cooldown");
            this.items.deserializeNBT(registries, compound.getCompound("items"));
            this.isBlacklist = compound.getBoolean("blacklist");
        }
    }
}

