/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityImpl;
import de.ellpeck.naturesaura.blocks.tiles.ITickableBlockEntity;
import de.ellpeck.naturesaura.blocks.tiles.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.FarmlandWaterManager;
import net.neoforged.neoforge.common.ticket.AABBTicket;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class BlockEntitySpring
extends BlockEntityImpl
implements ITickableBlockEntity {
    public final IFluidHandler tank = new InfiniteTank();
    private AABBTicket waterTicket;

    public BlockEntitySpring(BlockPos pos, BlockState state) {
        super(ModBlockEntities.SPRING, pos, state);
    }

    public void onLoad() {
        super.onLoad();
        if (!this.level.isClientSide) {
            AABB area = new AABB(this.worldPosition).inflate(5.0, 1.0, 5.0);
            this.waterTicket = FarmlandWaterManager.addAABBTicket((Level)this.level, (AABB)area);
        }
    }

    public void setRemoved() {
        super.setRemoved();
        if (!this.level.isClientSide && this.waterTicket != null && this.waterTicket.isValid()) {
            this.waterTicket.invalidate();
            this.waterTicket = null;
        }
    }

    @Override
    public void tick() {
        int level;
        if (this.level.isClientSide || this.level.getGameTime() % 35L != 0L) {
            return;
        }
        BlockPos up = this.worldPosition.above();
        BlockState upState = this.level.getBlockState(up);
        if (upState.hasProperty((Property)BlockStateProperties.LEVEL_CAULDRON) && (level = ((Integer)upState.getValue((Property)BlockStateProperties.LEVEL_CAULDRON)).intValue()) < 3 && this.tryConsumeAura(2500)) {
            this.level.setBlockAndUpdate(up, (BlockState)upState.setValue((Property)BlockStateProperties.LEVEL_CAULDRON, (Comparable)Integer.valueOf(level + 1)));
            this.level.playSound(null, up, SoundEvents.BUCKET_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
            return;
        }
        int spongeRadius = 2;
        for (int x = -spongeRadius; x <= spongeRadius; ++x) {
            for (int y = -spongeRadius; y <= spongeRadius; ++y) {
                for (int z = -spongeRadius; z <= spongeRadius; ++z) {
                    BlockPos pos = this.worldPosition.offset(x, y, z);
                    BlockState state = this.level.getBlockState(pos);
                    if (state.getBlock() != Blocks.SPONGE || !this.tryConsumeAura(2500)) continue;
                    this.level.setBlock(pos, Blocks.WET_SPONGE.defaultBlockState(), 2);
                    this.level.levelEvent(2001, pos, Block.getId((BlockState)Blocks.WATER.defaultBlockState()));
                    return;
                }
            }
        }
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BlockPos side = this.worldPosition.relative(dir);
            if (!this.isLava(side, true) || !this.tryConsumeAura(1500)) continue;
            this.level.setBlockAndUpdate(side, EventHooks.fireFluidPlaceBlockEvent((LevelAccessor)this.level, (BlockPos)side, (BlockPos)side, (BlockState)Blocks.OBSIDIAN.defaultBlockState()));
            this.level.levelEvent(1501, side, 0);
            return;
        }
        BlockPos twoUp = this.worldPosition.above(2);
        if (this.isLava(twoUp, false) && (this.level.getBlockState(up).isAir() || this.isLava(up, false)) && this.tryConsumeAura(150)) {
            this.level.setBlockAndUpdate(up, EventHooks.fireFluidPlaceBlockEvent((LevelAccessor)this.level, (BlockPos)up, (BlockPos)twoUp, (BlockState)Blocks.STONE.defaultBlockState()));
            this.level.levelEvent(1501, up, 0);
            return;
        }
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BlockPos twoSide = this.worldPosition.relative(dir, 2);
            BlockPos side = this.worldPosition.relative(dir);
            if (!this.isLava(twoSide, false) || !this.level.getBlockState(side).isAir() && !this.isLava(side, false) || !this.tryConsumeAura(100)) continue;
            this.level.setBlockAndUpdate(side, EventHooks.fireFluidPlaceBlockEvent((LevelAccessor)this.level, (BlockPos)side, (BlockPos)twoSide, (BlockState)Blocks.COBBLESTONE.defaultBlockState()));
            this.level.levelEvent(1501, side, 0);
            return;
        }
    }

    @Override
    public boolean allowsLowerLimiter() {
        return true;
    }

    public boolean tryConsumeAura(int amount) {
        if (!this.canUseRightNow(amount)) {
            return false;
        }
        BlockPos pos = IAuraChunk.getHighestSpot(this.level, this.worldPosition, 35, this.worldPosition);
        IAuraChunk.getAuraChunk(this.level, pos).drainAura(pos, amount);
        return true;
    }

    private boolean isLava(BlockPos offset, boolean source) {
        FluidState state = this.level.getFluidState(offset);
        return (!source || state.isSource()) && state.is(FluidTags.LAVA);
    }

    private class InfiniteTank
    implements IFluidTank,
    IFluidHandler {
        private InfiniteTank() {
        }

        public FluidStack getFluid() {
            return new FluidStack((Fluid)Fluids.WATER, 1000);
        }

        public int getFluidAmount() {
            return 1000;
        }

        public int getCapacity() {
            return 1000;
        }

        public boolean isFluidValid(FluidStack stack) {
            return stack.getFluid().defaultFluidState().is(FluidTags.WATER);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            int drain = Math.min(maxDrain, 1000);
            int auraUsed = Mth.ceil((float)((float)drain / 2.0f));
            if (!BlockEntitySpring.this.canUseRightNow(auraUsed)) {
                return FluidStack.EMPTY;
            }
            if (action.execute()) {
                BlockEntitySpring.this.tryConsumeAura(auraUsed);
            }
            return new FluidStack((Fluid)Fluids.WATER, drain);
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (this.isFluidValid(resource)) {
                return this.drain(resource.getAmount(), action);
            }
            return FluidStack.EMPTY;
        }

        public int getTanks() {
            return 1;
        }

        public FluidStack getFluidInTank(int tank) {
            return this.getFluid();
        }

        public int getTankCapacity(int tank) {
            return this.getCapacity();
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            return this.isFluidValid(stack);
        }
    }
}

