/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.items.tools;

import de.ellpeck.naturesaura.data.ItemModelGenerator;
import de.ellpeck.naturesaura.items.ModItems;
import de.ellpeck.naturesaura.reg.ICustomItemModel;
import de.ellpeck.naturesaura.reg.IModItem;
import de.ellpeck.naturesaura.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;

public class ItemHoe
extends HoeItem
implements IModItem,
ICustomItemModel {
    private final String baseName;

    public ItemHoe(String baseName, Tier material, int speed) {
        super(material, new Item.Properties().attributes(HoeItem.createAttributes((Tier)material, (float)0.0f, (float)speed)));
        this.baseName = baseName;
        ModRegistry.ALL_ITEMS.add(this);
    }

    public InteractionResult useOn(UseOnContext context) {
        if (this == ModItems.INFUSED_IRON_HOE) {
            Level level = context.getLevel();
            InteractionResult result = super.useOn(context);
            if (!level.isClientSide && result.consumesAction()) {
                ItemStack seed = ItemStack.EMPTY;
                RandomSource random = level.getRandom();
                BlockPos pos = context.getClickedPos();
                if (random.nextInt(5) == 0) {
                    seed = new ItemStack((ItemLike)Items.WHEAT_SEEDS);
                } else if (random.nextInt(10) == 0) {
                    int rand = random.nextInt(3);
                    if (rand == 0) {
                        seed = new ItemStack((ItemLike)Items.MELON_SEEDS);
                    } else if (rand == 1) {
                        seed = new ItemStack((ItemLike)Items.PUMPKIN_SEEDS);
                    } else if (rand == 2) {
                        seed = new ItemStack((ItemLike)Items.BEETROOT_SEEDS);
                    }
                }
                if (!seed.isEmpty()) {
                    ItemEntity item = new ItemEntity(level, (double)((float)pos.getX() + random.nextFloat()), (double)((float)pos.getY() + 1.0f), (double)((float)pos.getZ() + random.nextFloat()), seed);
                    level.addFreshEntity((Entity)item);
                }
            }
            return result;
        }
        if (this == ModItems.SKY_HOE) {
            boolean success = false;
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos offset = context.getClickedPos().offset(x, 0, z);
                    BlockHitResult newResult = new BlockHitResult(context.getClickLocation(), context.getClickedFace(), offset, context.isInside());
                    UseOnContext newContext = new UseOnContext(context.getPlayer(), context.getHand(), newResult);
                    success |= super.useOn(newContext).consumesAction();
                }
            }
            return success ? InteractionResult.SUCCESS : InteractionResult.PASS;
        }
        return super.useOn(context);
    }

    public boolean mineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity miningEntity) {
        Block block;
        if (!miningEntity.isShiftKeyDown() && (stack.getItem() == ModItems.SKY_HOE || stack.getItem() == ModItems.DEPTH_HOE) && ((block = level.getBlockState(pos).getBlock()) instanceof BushBlock || stack.getItem() == ModItems.DEPTH_HOE && block instanceof LeavesBlock) && !level.isClientSide) {
            int range = 3;
            for (int x = -range; x <= range; ++x) {
                for (int y = -range; y <= range; ++y) {
                    for (int z = -range; z <= range; ++z) {
                        BlockPos offset;
                        BlockState offState;
                        if (x == 0 && y == 0 && z == 0 || !((offState = level.getBlockState(offset = pos.offset(x, y, z))).getBlock() instanceof BushBlock) && (stack.getItem() != ModItems.DEPTH_HOE || !(offState.getBlock() instanceof LeavesBlock))) continue;
                        BlockEntity entity = offState.hasBlockEntity() ? level.getBlockEntity(offset) : null;
                        Block.dropResources((BlockState)offState, (Level)level, (BlockPos)offset, (BlockEntity)entity, null, (ItemStack)stack);
                        level.setBlock(offset, Blocks.AIR.defaultBlockState(), 3);
                    }
                }
            }
        }
        return super.mineBlock(stack, level, state, pos, miningEntity);
    }

    @Override
    public String getBaseName() {
        return this.baseName;
    }

    @Override
    public void generateCustomItemModel(ItemModelGenerator generator) {
        ((ItemModelBuilder)generator.withExistingParent(this.getBaseName(), "item/handheld")).texture("layer0", "item/" + this.getBaseName());
    }
}

