/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.comforts;

import com.illusivesoulworks.comforts.ComfortsCommonMod;
import com.illusivesoulworks.comforts.ComfortsNeoForgeClientMod;
import com.illusivesoulworks.comforts.common.ComfortsCommonEventsListener;
import com.illusivesoulworks.comforts.common.ComfortsRegistry;
import com.illusivesoulworks.comforts.common.SleepDataAttachment;
import com.illusivesoulworks.comforts.common.capability.ISleepData;
import com.illusivesoulworks.comforts.common.network.ComfortsClientPayloadHandler;
import com.illusivesoulworks.comforts.common.network.SPacketAutoSleep;
import com.illusivesoulworks.comforts.common.network.SPacketPlaceBag;
import com.illusivesoulworks.comforts.common.registry.RegistryObject;
import com.illusivesoulworks.comforts.data.ComfortsBlockTagsProvider;
import com.illusivesoulworks.comforts.data.ComfortsItemTagProvider;
import com.illusivesoulworks.comforts.data.ComfortsLootTableProvider;
import com.illusivesoulworks.comforts.data.ComfortsRecipeProvider;
import com.illusivesoulworks.comforts.data.HammockEnabledCondition;
import com.illusivesoulworks.comforts.data.SleepingBagEnabledCondition;
import com.mojang.serialization.MapCodec;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@Mod(value="comforts")
public class ComfortsNeoForgeMod {
    private static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"comforts");
    private static final DeferredRegister<MapCodec<? extends ICondition>> CONDITIONS = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.CONDITION_CODECS, (String)"comforts");
    public static final Supplier<AttachmentType<? extends ISleepData>> SLEEP_DATA = ATTACHMENT_TYPES.register("sleep_data", () -> AttachmentType.serializable(SleepDataAttachment::new).copyOnDeath().build());
    public static final Supplier<MapCodec<? extends ICondition>> SLEEPING_BAG_CONDITION = CONDITIONS.register("sleeping_bag_enabled", () -> SleepingBagEnabledCondition.CODEC);
    public static final Supplier<MapCodec<? extends ICondition>> HAMMOCK_CONDITION = CONDITIONS.register("hammock_enabled", () -> HammockEnabledCondition.CODEC);

    public ComfortsNeoForgeMod(IEventBus eventBus) {
        ComfortsCommonMod.init();
        ComfortsCommonMod.initConfig();
        if (FMLEnvironment.dist == Dist.CLIENT) {
            ComfortsNeoForgeClientMod.init(eventBus);
        }
        ATTACHMENT_TYPES.register(eventBus);
        CONDITIONS.register(eventBus);
        eventBus.addListener(this::setup);
        eventBus.addListener(this::registerPayloadHandler);
        eventBus.addListener(this::creativeTab);
        eventBus.addListener(this::gatherData);
    }

    private void gatherData(GatherDataEvent evt) {
        DataGenerator generator = evt.getGenerator();
        if (evt.includeServer()) {
            ExistingFileHelper existingFileHelper = evt.getExistingFileHelper();
            CompletableFuture lookupProvider = evt.getLookupProvider();
            DataGenerator gen = evt.getGenerator();
            PackOutput packOutput = gen.getPackOutput();
            ComfortsBlockTagsProvider blockTagsProvider = new ComfortsBlockTagsProvider(packOutput, lookupProvider, "comforts", existingFileHelper);
            generator.addProvider(true, (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(ComfortsLootTableProvider::new, LootContextParamSets.BLOCK)), lookupProvider));
            generator.addProvider(true, (DataProvider)new ComfortsRecipeProvider(packOutput, lookupProvider));
            generator.addProvider(true, (DataProvider)blockTagsProvider);
            generator.addProvider(true, (DataProvider)new ComfortsItemTagProvider(packOutput, lookupProvider, blockTagsProvider.contentsGetter(), "comforts", existingFileHelper));
        }
    }

    private void setup(FMLCommonSetupEvent evt) {
        NeoForge.EVENT_BUS.register((Object)new ComfortsCommonEventsListener());
    }

    private void registerPayloadHandler(RegisterPayloadHandlersEvent evt) {
        evt.registrar("comforts").playToClient(SPacketAutoSleep.TYPE, SPacketAutoSleep.STREAM_CODEC, ComfortsClientPayloadHandler.getInstance()::handleAutoSleep);
        evt.registrar("comforts").playToClient(SPacketPlaceBag.TYPE, SPacketPlaceBag.STREAM_CODEC, ComfortsClientPayloadHandler.getInstance()::handlePlaceBag);
    }

    private void creativeTab(BuildCreativeModeTabContentsEvent evt) {
        ResourceKey tab = evt.getTabKey();
        if (tab == CreativeModeTabs.COLORED_BLOCKS || tab == CreativeModeTabs.FUNCTIONAL_BLOCKS) {
            for (RegistryObject<Block> value : ComfortsRegistry.SLEEPING_BAGS.values()) {
                evt.accept((ItemLike)value.get());
            }
            for (RegistryObject<Block> value : ComfortsRegistry.HAMMOCKS.values()) {
                evt.accept((ItemLike)value.get());
            }
        }
        if (tab == CreativeModeTabs.FUNCTIONAL_BLOCKS) {
            evt.accept((ItemLike)ComfortsRegistry.ROPE_AND_NAIL_ITEM.get());
        }
    }
}

