/*
 * Decompiled with CFR 0.152.
 */
package reliquary.block;

import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import reliquary.block.tile.ApothecaryCauldronBlockEntity;
import reliquary.init.ModBlocks;
import reliquary.item.ICreativeTabItemGenerator;
import reliquary.reference.Config;
import reliquary.util.BlockEntityHelper;
import reliquary.util.WorldHelper;

public class ApothecaryCauldronBlock
extends Block
implements EntityBlock,
ICreativeTabItemGenerator {
    public static final IntegerProperty LEVEL = IntegerProperty.create((String)"level", (int)0, (int)3);
    private static final VoxelShape INSIDE = ApothecaryCauldronBlock.box((double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape SHAPE = Stream.of(Block.box((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0), Block.box((double)2.0, (double)0.0, (double)2.0, (double)4.0, (double)1.0, (double)4.0), Block.box((double)12.0, (double)0.0, (double)2.0, (double)14.0, (double)1.0, (double)4.0), Block.box((double)12.0, (double)0.0, (double)12.0, (double)14.0, (double)1.0, (double)14.0), Block.box((double)2.0, (double)0.0, (double)12.0, (double)4.0, (double)1.0, (double)14.0), Block.box((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)13.0, (double)2.0), Block.box((double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)13.0, (double)16.0), Block.box((double)14.0, (double)2.0, (double)2.0, (double)16.0, (double)13.0, (double)14.0), Block.box((double)0.0, (double)2.0, (double)2.0, (double)2.0, (double)13.0, (double)14.0), Block.box((double)1.0, (double)13.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0), Block.box((double)1.0, (double)13.0, (double)1.0, (double)15.0, (double)14.0, (double)2.0), Block.box((double)1.0, (double)13.0, (double)14.0, (double)15.0, (double)14.0, (double)15.0), Block.box((double)14.0, (double)13.0, (double)2.0, (double)15.0, (double)14.0, (double)14.0), Block.box((double)0.0, (double)14.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0), Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0), Block.box((double)14.0, (double)14.0, (double)2.0, (double)16.0, (double)16.0, (double)14.0), Block.box((double)0.0, (double)14.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();

    public ApothecaryCauldronBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(1.5f, 5.0f).noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LEVEL, (Comparable)Integer.valueOf(0)));
    }

    @Override
    public void addCreativeTabItems(Consumer<ItemStack> itemConsumer) {
        if (Boolean.TRUE.equals(Config.COMMON.disable.disablePotions.get())) {
            return;
        }
        itemConsumer.accept(new ItemStack((ItemLike)this));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LEVEL});
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public VoxelShape getInteractionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return INSIDE;
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        ApothecaryCauldronBlockEntity cauldron;
        if (!level.isClientSide && (cauldron = (ApothecaryCauldronBlockEntity)level.getBlockEntity(pos)) != null) {
            cauldron.handleCollidingEntity(level, pos, entity);
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack heldItem, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return !heldItem.isEmpty() ? ItemInteractionResult.SUCCESS : ItemInteractionResult.CONSUME;
        }
        if (heldItem.isEmpty()) {
            return ItemInteractionResult.CONSUME;
        }
        ApothecaryCauldronBlockEntity cauldron = (ApothecaryCauldronBlockEntity)level.getBlockEntity(pos);
        if (cauldron != null) {
            return cauldron.handleBlockActivation(level, player, hand, pos);
        }
        return ItemInteractionResult.CONSUME;
    }

    public void handlePrecipitation(BlockState state, Level level, BlockPos pos, Biome.Precipitation precipitation) {
        if (precipitation == Biome.Precipitation.RAIN && level.getRandom().nextFloat() < 0.05f) {
            WorldHelper.getBlockEntity((BlockGetter)level, pos, ApothecaryCauldronBlockEntity.class).ifPresent(ApothecaryCauldronBlockEntity::fillWithRain);
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        ApothecaryCauldronBlockEntity cauldron = (ApothecaryCauldronBlockEntity)level.getBlockEntity(pos);
        if (cauldron != null) {
            return cauldron.getLiquidLevel();
        }
        return 0;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ApothecaryCauldronBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return BlockEntityHelper.createTickerHelper(blockEntityType, ModBlocks.APOTHECARY_CAULDRON_TILE_TYPE.get(), (l, p, s, be) -> be.serverTick(l, p));
    }
}

